/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.sasn1;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.sasn1.BerGenerator;

public class BerOctetStringGenerator
extends BerGenerator {
    public BerOctetStringGenerator(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.writeBerHeader(36);
    }

    public BerOctetStringGenerator(OutputStream outputStream, int n, boolean bl) throws IOException {
        super(outputStream, n, bl);
        this.writeBerHeader(36);
    }

    public OutputStream getOctetOutputStream() {
        return new BerOctetStream();
    }

    public OutputStream getOctetOutputStream(byte[] byArray) {
        return new BufferedBerOctetStream(byArray);
    }

    private class BerOctetStream
    extends OutputStream {
        private byte[] _buf = new byte[1];

        private BerOctetStream() {
        }

        @Override
        public void write(int n) throws IOException {
            this._buf[0] = (byte)n;
            BerOctetStringGenerator.this._out.write(new DEROctetString(this._buf).getEncoded());
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            BerOctetStringGenerator.this._out.write(new DEROctetString(byArray).getEncoded());
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            BerOctetStringGenerator.this._out.write(new DEROctetString(byArray2).getEncoded());
        }

        @Override
        public void close() throws IOException {
            BerOctetStringGenerator.this.writeBerEnd();
        }
    }

    private class BufferedBerOctetStream
    extends OutputStream {
        private byte[] _buf;
        private int _off;

        BufferedBerOctetStream(byte[] byArray) {
            this._buf = byArray;
            this._off = 0;
        }

        @Override
        public void write(int n) throws IOException {
            this._buf[this._off++] = (byte)n;
            if (this._off == this._buf.length) {
                BerOctetStringGenerator.this._out.write(new DEROctetString(this._buf).getEncoded());
                this._off = 0;
            }
        }

        @Override
        public void close() throws IOException {
            if (this._off != 0) {
                byte[] byArray = new byte[this._off];
                System.arraycopy(this._buf, 0, byArray, 0, this._off);
                BerOctetStringGenerator.this._out.write(new DEROctetString(byArray).getEncoded());
            }
            BerOctetStringGenerator.this.writeBerEnd();
        }
    }
}

