/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.CharConversionException;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CharConverter;
import org.mozilla.jss.asn1.CharacterString;
import org.mozilla.jss.asn1.Tag;

public class TeletexString
extends CharacterString
implements ASN1Value {
    public static final Tag TAG = new Tag(Tag.UNIVERSAL, 20L);
    private static final Template templateInstance = new Template();

    public Tag getTag() {
        return TAG;
    }

    public TeletexString(char[] cArray) throws CharConversionException {
        super(cArray);
    }

    public TeletexString(String string) throws CharConversionException {
        super(string);
    }

    CharConverter getCharConverter() {
        return new TeletexConverter();
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    private static class TeletexConverter
    implements CharConverter {
        private TeletexConverter() {
        }

        public char[] byteToChar(byte[] byArray, int n, int n2) throws CharConversionException {
            char[] cArray = new char[n2];
            int n3 = n;
            for (int i = 0; i < n2; ++i) {
                cArray[i] = (char)(byArray[n3] & 0xFF);
                ++n3;
            }
            return cArray;
        }

        public byte[] charToByte(char[] cArray, int n, int n2) throws CharConversionException {
            byte[] byArray = new byte[n2];
            int n3 = 0;
            int n4 = n;
            while (n3 < n2) {
                if ((cArray[n4] & 0xFF00) != 0) {
                    throw new CharConversionException("Invalid character for TeletexString");
                }
                byArray[n3] = (byte)(cArray[n4] & 0xFF);
                ++n3;
                ++n4;
            }
            return byArray;
        }
    }

    public static class Template
    extends CharacterString.Template
    implements ASN1Template {
        protected Tag getTag() {
            return TAG;
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        protected CharConverter getCharConverter() {
            return new TeletexConverter();
        }

        protected CharacterString generateInstance(char[] cArray) throws CharConversionException {
            return new TeletexString(cArray);
        }

        protected String typeName() {
            return "TeletexString";
        }
    }
}

