/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.Algorithm;

public class DigestAlgorithm
extends Algorithm {
    private int outputSize;
    private static Hashtable oidMap = new Hashtable();
    public static final DigestAlgorithm MD2 = new DigestAlgorithm(24, "MD2", OBJECT_IDENTIFIER.RSA_DIGEST.subBranch(2L), 16);
    public static final DigestAlgorithm MD5 = new DigestAlgorithm(25, "MD5", OBJECT_IDENTIFIER.RSA_DIGEST.subBranch(5L), 16);
    public static final DigestAlgorithm SHA1 = new DigestAlgorithm(26, "SHA-1", OBJECT_IDENTIFIER.ALGORITHM.subBranch(26L), 20);
    public static final DigestAlgorithm SHA256 = new DigestAlgorithm(38, "SHA-256", OBJECT_IDENTIFIER.HASH_ALGORITHM.subBranch(1L), 32);
    public static final DigestAlgorithm SHA384 = new DigestAlgorithm(39, "SHA-384", OBJECT_IDENTIFIER.HASH_ALGORITHM.subBranch(2L), 48);
    public static final DigestAlgorithm SHA512 = new DigestAlgorithm(40, "SHA-512", OBJECT_IDENTIFIER.HASH_ALGORITHM.subBranch(3L), 64);

    protected DigestAlgorithm(int n, String string, OBJECT_IDENTIFIER oBJECT_IDENTIFIER, int n2) {
        super(n, string, oBJECT_IDENTIFIER);
        this.outputSize = n2;
        if (oBJECT_IDENTIFIER != null && oidMap.get(oBJECT_IDENTIFIER) == null) {
            oidMap.put(oBJECT_IDENTIFIER, this);
        }
    }

    public static DigestAlgorithm fromOID(OBJECT_IDENTIFIER oBJECT_IDENTIFIER) throws NoSuchAlgorithmException {
        Object v = oidMap.get(oBJECT_IDENTIFIER);
        if (v == null) {
            throw new NoSuchAlgorithmException();
        }
        return (DigestAlgorithm)v;
    }

    public int getOutputSize() {
        return this.outputSize;
    }
}

