/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs7;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkcs7.ContentInfo;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;

public class DigestedData
implements ASN1Value {
    private INTEGER version;
    private AlgorithmIdentifier digestAlgorithm;
    private ContentInfo contentInfo;
    private OCTET_STRING digest;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;

    public INTEGER getVersion() {
        return this.version;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public OCTET_STRING getDigest() {
        return this.digest;
    }

    private DigestedData() {
    }

    public DigestedData(INTEGER iNTEGER, AlgorithmIdentifier algorithmIdentifier, ContentInfo contentInfo, OCTET_STRING oCTET_STRING) {
        if (iNTEGER == null || algorithmIdentifier == null || contentInfo == null || oCTET_STRING == null) {
            throw new IllegalArgumentException("DigestedData constructor parameter is null");
        }
        this.version = iNTEGER;
        this.digestAlgorithm = algorithmIdentifier;
        this.contentInfo = contentInfo;
        this.digest = oCTET_STRING;
        this.sequence = new SEQUENCE();
        this.sequence.addElement(iNTEGER);
        this.sequence.addElement(algorithmIdentifier);
        this.sequence.addElement(contentInfo);
        this.sequence.addElement(oCTET_STRING);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.sequence.encode(outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(ContentInfo.getTemplate());
            this.seqt.addElement(OCTET_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new DigestedData((INTEGER)sEQUENCE.elementAt(0), (AlgorithmIdentifier)sEQUENCE.elementAt(1), (ContentInfo)sEQUENCE.elementAt(2), (OCTET_STRING)sEQUENCE.elementAt(3));
        }
    }
}

