/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.asn1.UTF8String;
import org.mozilla.jss.pkix.cmc.OtherInfo;
import org.mozilla.jss.util.Assert;

public class CMCStatusInfo
implements ASN1Value {
    public static final INTEGER BODYIDMAX = new INTEGER("4294967295");
    private INTEGER status;
    private SEQUENCE bodyList;
    private UTF8String statusString;
    private OtherInfo otherInfo;
    public static final int SUCCESS = 0;
    public static final int RESERVED = 1;
    public static final int FAILED = 2;
    public static final int PENDING = 3;
    public static final int NOSUPPORT = 4;
    public static final int CONFIRM_REQUIRED = 5;
    public static final String[] STATUS = new String[]{"success", "reserved", "failed", "pending", "not supported", "confirm required"};
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private CMCStatusInfo() {
    }

    public CMCStatusInfo(int n, SEQUENCE sEQUENCE) {
        this.status = new INTEGER(n);
        this.bodyList = sEQUENCE;
        this.statusString = null;
        this.otherInfo = null;
    }

    public CMCStatusInfo(int n, SEQUENCE sEQUENCE, String string, OtherInfo otherInfo) {
        this.status = new INTEGER(n);
        this.bodyList = sEQUENCE;
        if (string != null) {
            try {
                this.statusString = new UTF8String(string);
            }
            catch (Exception exception) {}
        } else {
            this.statusString = null;
        }
        this.otherInfo = otherInfo;
    }

    public CMCStatusInfo(INTEGER iNTEGER, SEQUENCE sEQUENCE, UTF8String uTF8String, OtherInfo otherInfo) {
        this.status = iNTEGER;
        this.bodyList = sEQUENCE;
        this.statusString = uTF8String;
        this.otherInfo = otherInfo;
    }

    public void setStatusString(String string) {
        if (string != null) {
            try {
                this.statusString = new UTF8String(string);
            }
            catch (Exception exception) {}
        } else {
            this.statusString = null;
        }
    }

    public void addBodyPartID(int n) {
        INTEGER iNTEGER = new INTEGER(n);
        Assert._assert(iNTEGER.compareTo(BODYIDMAX) <= 0);
        this.bodyList.addElement(iNTEGER);
    }

    public int getStatus() {
        return this.status.intValue();
    }

    public SEQUENCE getBodyList() {
        return this.bodyList;
    }

    public String getStatusString() {
        if (this.statusString != null) {
            return this.statusString.toString();
        }
        return null;
    }

    public OtherInfo getOtherInfo() {
        return this.otherInfo;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement(this.status);
        sEQUENCE.addElement(this.bodyList);
        if (this.statusString != null) {
            sEQUENCE.addElement(this.statusString);
        }
        if (this.otherInfo != null) {
            sEQUENCE.addElement(this.otherInfo);
        }
        sEQUENCE.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(new SEQUENCE.OF_Template(INTEGER.getTemplate()));
            this.seqt.addOptionalElement(UTF8String.getTemplate());
            this.seqt.addOptionalElement(OtherInfo.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new CMCStatusInfo((INTEGER)sEQUENCE.elementAt(0), (SEQUENCE)sEQUENCE.elementAt(1), (UTF8String)sEQUENCE.elementAt(2), (OtherInfo)sEQUENCE.elementAt(3));
        }
    }
}

