/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmmf;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.asn1.UTF8String;
import org.mozilla.jss.util.Assert;

public class PKIStatusInfo
implements ASN1Value {
    private INTEGER status;
    private SEQUENCE statusString;
    private int failInfo;
    private boolean hasFailInfo;
    public static final int granted = 0;
    public static final int grantedWithMods = 1;
    public static final int rejection = 2;
    public static final int waiting = 3;
    public static final int revocationWarning = 4;
    public static final int revocationNotification = 5;
    public static final int keyUpdateWarning = 6;
    public static final int badAlg = Integer.MIN_VALUE;
    public static final int badMessageCheck = 0x40000000;
    public static final int badRequest = 0x20000000;
    public static final int badTime = 0x10000000;
    public static final int badCertId = 0x8000000;
    public static final int badDataFormat = 0x4000000;
    public static final int wrongAuthority = 0x2000000;
    public static final int incorrectData = 0x1000000;
    public static final int missingTimeStamp = 0x800000;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private PKIStatusInfo() {
    }

    public PKIStatusInfo(int n, int n2) {
        this.status = new INTEGER(n);
        this.statusString = new SEQUENCE();
        this.failInfo = n2;
        this.hasFailInfo = true;
    }

    public PKIStatusInfo(int n) {
        this.status = new INTEGER(n);
        this.statusString = new SEQUENCE();
        this.hasFailInfo = false;
    }

    public void setStatusString(SEQUENCE sEQUENCE) {
        this.statusString = sEQUENCE;
    }

    public void addFreeText(String string) {
        try {
            this.statusString.addElement(new UTF8String(string));
        }
        catch (CharConversionException charConversionException) {
            Assert.notReached("Error encoding to UTF8");
        }
    }

    public void addFreeText(UTF8String uTF8String) {
        this.statusString.addElement(uTF8String);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement(this.status);
        if (this.statusString.size() > 0) {
            sEQUENCE.addElement(this.statusString);
        }
        if (this.hasFailInfo) {
            byte[] byArray = new byte[]{(byte)((this.failInfo & 0xFF000000) >>> 24), (byte)((this.failInfo & 0xFF0000) >>> 16)};
            int n = 7;
            BIT_STRING bIT_STRING = new BIT_STRING(byArray, n);
            bIT_STRING.setRemoveTrailingZeroes(true);
            sEQUENCE.addElement(bIT_STRING);
        }
        sEQUENCE.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addOptionalElement(new SEQUENCE.OF_Template(UTF8String.getTemplate()));
            this.seqt.addOptionalElement(BIT_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            PKIStatusInfo pKIStatusInfo;
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            BIT_STRING bIT_STRING = (BIT_STRING)sEQUENCE.elementAt(2);
            if (bIT_STRING == null) {
                pKIStatusInfo = new PKIStatusInfo(((INTEGER)sEQUENCE.elementAt(0)).intValue());
            } else {
                BitSet bitSet = bIT_STRING.toBitSet();
                int n = 0;
                int n2 = 0;
                for (int i = Integer.MIN_VALUE; i > 0; i >>>= 1) {
                    if (bitSet.get(n2)) {
                        n |= i;
                    }
                    ++n2;
                }
                pKIStatusInfo = new PKIStatusInfo(((INTEGER)sEQUENCE.elementAt(0)).intValue(), n);
            }
            pKIStatusInfo.setStatusString((SEQUENCE)sEQUENCE.elementAt(1));
            return pKIStatusInfo;
        }
    }
}

