/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.crmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.NULL;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.crmf.POPOPrivKey;
import org.mozilla.jss.pkix.crmf.POPOSigningKey;
import org.mozilla.jss.util.Assert;

public class ProofOfPossession
implements ASN1Value {
    public static Type RA_VERIFIED = Type.RA_VERIFIED;
    public static Type SIGNATURE = Type.SIGNATURE;
    public static Type KEY_ENCIPHERMENT = Type.KEY_ENCIPHERMENT;
    public static Type KEY_AGREEMENT = Type.KEY_AGREEMENT;
    private Type type;
    private POPOSigningKey signature;
    private POPOPrivKey keyEncipherment;
    private POPOPrivKey keyAgreement;

    public Type getType() {
        return this.type;
    }

    public POPOSigningKey getSignature() {
        return this.signature;
    }

    public POPOPrivKey getKeyEncipherment() {
        return this.keyEncipherment;
    }

    public POPOPrivKey getKeyAgreement() {
        return this.keyAgreement;
    }

    private ProofOfPossession() {
    }

    private ProofOfPossession(Type type, POPOSigningKey pOPOSigningKey, POPOPrivKey pOPOPrivKey, POPOPrivKey pOPOPrivKey2) {
        this.type = type;
        this.signature = pOPOSigningKey;
        this.keyEncipherment = pOPOPrivKey;
        this.keyAgreement = pOPOPrivKey2;
    }

    public static ProofOfPossession createRaVerified() {
        return new ProofOfPossession(RA_VERIFIED, null, null, null);
    }

    public static ProofOfPossession createSignature(POPOSigningKey pOPOSigningKey) {
        return new ProofOfPossession(SIGNATURE, pOPOSigningKey, null, null);
    }

    public static ProofOfPossession createKeyEncipherment(POPOPrivKey pOPOPrivKey) {
        return new ProofOfPossession(KEY_ENCIPHERMENT, null, pOPOPrivKey, null);
    }

    public static ProofOfPossession createKeyAgreement(POPOPrivKey pOPOPrivKey) {
        return new ProofOfPossession(KEY_AGREEMENT, null, null, pOPOPrivKey);
    }

    public Tag getTag() {
        if (this.type == RA_VERIFIED) {
            return Tag.get(0L);
        }
        if (this.type == SIGNATURE) {
            return Tag.get(1L);
        }
        if (this.type == KEY_ENCIPHERMENT) {
            return Tag.get(2L);
        }
        Assert._assert(this.type == KEY_AGREEMENT);
        return Tag.get(3L);
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (this.type == RA_VERIFIED) {
            new NULL().encode(Tag.get(0L), outputStream);
        } else if (this.type == SIGNATURE) {
            this.signature.encode(Tag.get(1L), outputStream);
        } else if (this.type == KEY_ENCIPHERMENT) {
            EXPLICIT eXPLICIT = new EXPLICIT(Tag.get(2L), this.keyEncipherment);
            eXPLICIT.encode(outputStream);
        } else {
            Assert._assert(this.type == KEY_AGREEMENT);
            EXPLICIT eXPLICIT = new EXPLICIT(Tag.get(3L), this.keyAgreement);
            eXPLICIT.encode(outputStream);
        }
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        Assert._assert(tag.equals(this.getTag()));
        this.encode(outputStream);
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template choicet = new CHOICE.Template();

        public Template() {
            this.choicet.addElement(Tag.get(0L), NULL.getTemplate());
            this.choicet.addElement(Tag.get(1L), POPOSigningKey.getTemplate());
            EXPLICIT.Template template = new EXPLICIT.Template(Tag.get(2L), POPOPrivKey.getTemplate());
            this.choicet.addElement(template);
            template = new EXPLICIT.Template(Tag.get(3L), POPOPrivKey.getTemplate());
            this.choicet.addElement(template);
        }

        public boolean tagMatch(Tag tag) {
            return this.choicet.tagMatch(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            CHOICE cHOICE = (CHOICE)this.choicet.decode(inputStream);
            if (cHOICE.getTag().equals(Tag.get(0L))) {
                return ProofOfPossession.createRaVerified();
            }
            if (cHOICE.getTag().equals(Tag.get(1L))) {
                return ProofOfPossession.createSignature((POPOSigningKey)cHOICE.getValue());
            }
            if (cHOICE.getTag().equals(Tag.get(2L))) {
                EXPLICIT eXPLICIT = (EXPLICIT)cHOICE.getValue();
                return ProofOfPossession.createKeyEncipherment((POPOPrivKey)eXPLICIT.getContent());
            }
            Assert._assert(cHOICE.getTag().equals(Tag.get(3L)));
            EXPLICIT eXPLICIT = (EXPLICIT)cHOICE.getValue();
            return ProofOfPossession.createKeyAgreement((POPOPrivKey)eXPLICIT.getContent());
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            Assert.notReached("A CHOICE cannot be implicitly tagged");
            return this.decode(inputStream);
        }
    }

    public static class Type {
        static Type RA_VERIFIED = new Type();
        static Type SIGNATURE = new Type();
        static Type KEY_ENCIPHERMENT = new Type();
        static Type KEY_AGREEMENT = new Type();

        private Type() {
        }
    }
}

