/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Vector;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.tests.Constants;
import org.mozilla.jss.tests.FilePasswordCallback;

public class JSS_SelfServServer {
    private static Vector jssSupportedCiphers = new Vector();
    private static SSLServerSocket serverSock = null;
    private static SSLSocket sock = null;
    private String fServerCertNick = null;
    private String fServerHost = "localhost";
    private String fPasswordFile = "passwords";
    private String fCertDbPath = ".";
    private boolean TestInetAddress = false;
    private boolean success = true;
    public static int port = 29754;
    public static String usage = "\nUSAGE:\njava JSS_SelfServServer [certdb path] [password file]\n[server_host_name] [cert nickname] [testInetAddress: true|false]";

    public static void main(String[] stringArray) throws Exception {
        try {
            new JSS_SelfServServer().doIt(stringArray);
        }
        catch (Exception exception) {
            System.out.println("Exception " + exception.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    public void doIt(String[] stringArray) throws Exception {
        int n;
        if (stringArray.length < 1 || stringArray[0].toLowerCase().indexOf("-h") != -1) {
            System.out.println(usage);
            System.exit(1);
        }
        int n2 = 0;
        try {
            if (stringArray[0].length() > 0 && !stringArray[0].equals(".")) {
                this.fCertDbPath = stringArray[0];
            }
            if (stringArray[1].length() > 0 && !stringArray[1].equals("passwords")) {
                this.fPasswordFile = stringArray[1];
            }
            if (stringArray[2].length() > 0 && !stringArray[2].equals("localhost")) {
                this.fServerHost = stringArray[2];
            }
            if (stringArray[3].length() > 0) {
                this.fServerCertNick = stringArray[3];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        CryptoManager.initialize(this.fCertDbPath);
        CryptoManager cryptoManager = CryptoManager.getInstance();
        CryptoToken cryptoToken = cryptoManager.getInternalKeyStorageToken();
        FilePasswordCallback filePasswordCallback = new FilePasswordCallback(this.fPasswordFile);
        cryptoToken.login(filePasswordCallback);
        if (stringArray[4].equalsIgnoreCase("true")) {
            this.TestInetAddress = true;
        }
        SSLServerSocket.configServerSessionIDCache(10, 100, 100, null);
        for (n = 65281; n <= 65287; ++n) {
            if (n == 65285) continue;
            SSLSocket.setCipherPreferenceDefault(n, true);
        }
        n = 0;
        while (Constants.jssCipherSuites[n] != 0) {
            try {
                SSLSocket.setCipherPreferenceDefault(Constants.jssCipherSuites[n], true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        if (Constants.debug_level >= 3) {
            System.out.println("Server about .... to create socket");
        }
        if (this.TestInetAddress) {
            if (Constants.debug_level >= 3) {
                System.out.println("the HostName " + this.fServerHost + " the Inet Address " + InetAddress.getByName(this.fServerHost));
            }
            serverSock = new SSLServerSocket(port, 5, InetAddress.getByName(this.fServerHost), null, true);
        } else {
            if (Constants.debug_level >= 3) {
                System.out.println("Inet set to Null");
            }
            serverSock = new SSLServerSocket(port, 5, null, null, true);
        }
        if (Constants.debug_level >= 3) {
            System.out.println("Server created socket");
        }
        serverSock.requireClientAuth(21);
        serverSock.setServerCertNickname(this.fServerCertNick);
        if (Constants.debug_level >= 3) {
            System.out.println("Server specified cert by nickname");
        }
        System.out.println("Server ready to accept connections");
        while (true) {
            sock = (SSLSocket)serverSock.accept();
            sock.addHandshakeCompletedListener(new HandshakeListener("server", this));
            readWriteThread readWriteThread2 = new readWriteThread(sock, ++n2);
            readWriteThread2.start();
        }
    }

    public synchronized void setFailure() {
        this.success = false;
    }

    public synchronized boolean getSuccess() {
        return this.success;
    }

    public static class HandshakeListener
    implements SSLHandshakeCompletedListener {
        private String who;
        private JSS_SelfServServer boss;

        public HandshakeListener(String string, JSS_SelfServServer jSS_SelfServServer) {
            this.who = string;
            this.boss = jSS_SelfServServer;
        }

        public void handshakeCompleted(SSLHandshakeCompletedEvent sSLHandshakeCompletedEvent) {
            try {
                String string = this.who + " got a completed handshake ";
                SSLSecurityStatus sSLSecurityStatus = sSLHandshakeCompletedEvent.getStatus();
                string = sSLSecurityStatus.isSecurityOn() ? string + "(security is ON)" : string + "(security is OFF)";
                if (Constants.debug_level >= 3) {
                    System.out.println(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.boss.setFailure();
            }
        }
    }

    private class readWriteThread
    extends Thread {
        private SSLSocket socket = null;
        private int socketCntr = 0;

        public readWriteThread(SSLSocket sSLSocket, int n) {
            this.socket = sSLSocket;
            this.socketCntr = n;
        }

        public void run() {
            try {
                Object var1_1 = null;
                String string = null;
                InputStream inputStream = this.socket.getInputStream();
                OutputStream outputStream = this.socket.getOutputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
                while (true) {
                    if ((string = bufferedReader.readLine()) == null) {
                        continue;
                    }
                    System.out.println("Socket" + this.socketCntr + ": Received " + string);
                    System.out.println("Socket" + this.socketCntr + ": Writing hi back to client");
                    printWriter.print("Server saying hi on socket " + this.socketCntr + "\n");
                    printWriter.flush();
                }
            }
            catch (Exception exception) {
                System.out.println("Exception caught\n");
                exception.printStackTrace();
                System.exit(1);
                return;
            }
        }
    }
}

