/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.tests.Constants;
import org.mozilla.jss.tests.DSATestValues;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.tests.RSATestValues;
import org.mozilla.jss.tests.TestValues;

public class KeyFactoryTest {
    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 2) {
                System.out.println("Usage: java org.mozilla.jss.tests.KeyFactoryTest <dbdir> <passwordFile>");
                System.exit(1);
            }
            CryptoManager.initialize(stringArray[0]);
            CryptoToken cryptoToken = CryptoManager.getInstance().getInternalKeyStorageToken();
            FilePasswordCallback filePasswordCallback = new FilePasswordCallback(stringArray[1]);
            cryptoToken.login(filePasswordCallback);
            new KeyFactoryTest().doTest();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public void doTest() throws Throwable {
        boolean bl;
        DSATestValues dSATestValues;
        RSATestValues rSATestValues;
        block21: {
            block20: {
                String string = System.getProperty("java.vendor");
                rSATestValues = null;
                dSATestValues = null;
                bl = false;
                if (string.equals("IBM Corporation")) {
                    rSATestValues = new RSATestValues("IBMJCE");
                    dSATestValues = new DSATestValues("IBMJCE");
                } else {
                    rSATestValues = new RSATestValues();
                    dSATestValues = new DSATestValues();
                }
                try {
                    this.genPrivKeyFromSpec(rSATestValues);
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    if (Constants.debug_level > 3) {
                        System.out.println("InvalidKeySpecException caught genPrivKeyFromSpec(rsa): " + invalidKeySpecException.getMessage());
                    }
                    if (string.equals("IBM Corporation")) {
                        System.out.println("Could not generated a RSA private key from a\njava.security.spec.RSAPrivateKeySpec. Not supported IBMJCE");
                    } else {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    if (Constants.debug_level <= 3) break block20;
                    System.out.println("Exception caught genPrivKeyFromSpec(rsa): " + exception.getMessage());
                }
            }
            try {
                this.genPrivKeyFromSpec(dSATestValues);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                if (Constants.debug_level > 3) {
                    System.out.println("InvalidKeySpecException caught genPrivKeyFromSpec(dsa): " + invalidKeySpecException.getMessage());
                }
                bl = true;
            }
            catch (Exception exception) {
                if (Constants.debug_level <= 3) break block21;
                System.out.println("Exception caught genPrivKeyFromSpec(dsa): " + exception.getMessage());
            }
        }
        try {
            this.genPubKeyFromSpec(rSATestValues);
        }
        catch (Exception exception) {
            if (Constants.debug_level > 3) {
                System.out.println("Exception caught genPubKeyFromSpec(rsa): " + exception.getMessage());
            }
            bl = true;
        }
        try {
            this.genPubKeyFromSpec(dSATestValues);
        }
        catch (Exception exception) {
            if (Constants.debug_level > 3) {
                System.out.println("Exception caught genPubKeyFromSpec(dsa): " + exception.getMessage());
            }
            bl = true;
        }
        if (bl) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    public void genPrivKeyFromSpec(TestValues testValues) throws Throwable {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(testValues.keyGenAlg, testValues.provider);
        keyPairGenerator.initialize(512);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        KeyFactory keyFactory = KeyFactory.getInstance(testValues.keyGenAlg, testValues.provider);
        Object t = keyFactory.getKeySpec(keyPair.getPrivate(), testValues.privateKeySpecClass);
        KeyFactory keyFactory2 = KeyFactory.getInstance(testValues.keyGenAlg, "Mozilla-JSS");
        PrivateKey privateKey = keyFactory2.generatePrivate((KeySpec)t);
        this.signVerify(testValues.sigAlg, privateKey, "Mozilla-JSS", keyPair.getPublic(), testValues.provider);
        System.out.println("Successfully generated a " + testValues.keyGenAlg + " private key from a " + testValues.privateKeySpecClass.getName());
    }

    public void signVerify(String string, PrivateKey privateKey, String string2, PublicKey publicKey, String string3) throws Throwable {
        Signature signature = Signature.getInstance(string, string2);
        signature.initSign(privateKey);
        String string4 = "blah blah blah sign me";
        signature.update(string4.getBytes("UTF-8"));
        byte[] byArray = signature.sign();
        Signature signature2 = Signature.getInstance(string, string3);
        signature2.initVerify(publicKey);
        signature2.update(string4.getBytes("UTF-8"));
        if (!signature2.verify(byArray)) {
            throw new Exception("Private/public key mismatch: signing alg=" + string + ", signing provider=" + string2 + ", verifying provider = " + string3);
        }
    }

    public void genPubKeyFromSpec(TestValues testValues) throws Throwable {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(testValues.keyGenAlg, testValues.provider);
        keyPairGenerator.initialize(512);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        KeyFactory keyFactory = KeyFactory.getInstance(testValues.keyGenAlg, testValues.provider);
        Object t = keyFactory.getKeySpec(keyPair.getPublic(), testValues.publicKeySpecClass);
        KeyFactory keyFactory2 = KeyFactory.getInstance(testValues.keyGenAlg, "Mozilla-JSS");
        PublicKey publicKey = keyFactory2.generatePublic((KeySpec)t);
        this.signVerify(testValues.sigAlg, keyPair.getPrivate(), testValues.provider, publicKey, "Mozilla-JSS");
        System.out.println("Successfully generated a " + testValues.keyGenAlg + " public key from a " + testValues.publicKeySpecClass.getName());
    }
}

