/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.util;

public class Debug {
    public static final boolean DEBUG = false;
    public static final int OBNOXIOUS = 10;
    public static final int VERBOSE = 5;
    public static final int ERROR = 1;
    public static final int QUIET = 0;
    private static int mDebugLevel = 1;

    public static synchronized void trace(int n, String string) {
        if (n <= mDebugLevel) {
            System.out.println(Thread.currentThread().getName() + ": " + string);
            System.out.flush();
        }
    }

    public static synchronized void trace(String string) {
        Debug.trace(5, string);
    }

    public static synchronized void setLevel(int n) {
        mDebugLevel = n;
        Debug.setNativeLevel(n);
    }

    private static native void setNativeLevel(int var0);

    public static synchronized int getLevel() {
        return mDebugLevel;
    }

    public static synchronized String getLevelStr() {
        switch (mDebugLevel) {
            case 0: {
                return "QUIET";
            }
            case 1: {
                return "ERROR";
            }
            case 5: {
                return "VERBOSE";
            }
            case 10: {
                return "OBNOXIOUS";
            }
        }
        return String.valueOf(mDebugLevel);
    }
}

