/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.ts;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.ts.TSPAlgoritmos;
import es.mityc.javasign.tsa.ITimeStampValidator;
import es.mityc.javasign.tsa.TSValidationResult;
import es.mityc.javasign.tsa.TimeStampException;
import es.mityc.javasign.utils.Base64Coder;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.tsp.GenTimeAccuracy;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;

public class TimeStampValidator
implements ITimeStampValidator {
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibTSA");
    static Log log = LogFactory.getLog((String)TimeStampValidator.class.getName());

    public TSValidationResult validateTimeStamp(byte[] sealedData, byte[] timeStamp) throws TimeStampException {
        X500Principal signer;
        TimeStampToken tst = null;
        TSValidationResult tsv = new TSValidationResult();
        try {
            tst = new TimeStampToken(new CMSSignedData(timeStamp));
        }
        catch (CMSException e) {
            try {
                TimeStampResponse tsr = new TimeStampResponse(timeStamp);
                tst = tsr.getTimeStampToken();
                if (tst == null) {
                    throw new TimeStampException(I18N.getLocalMessage("i18n.mityc.ts.error2"));
                }
            }
            catch (TSPException ex) {
                throw new TimeStampException(I18N.getLocalMessage("i18n.mityc.ts.error2"));
            }
            catch (IOException ex) {
                throw new TimeStampException(I18N.getLocalMessage("i18n.mityc.ts.error2"));
            }
        }
        catch (TSPException e) {
            throw new TimeStampException(I18N.getLocalMessage("i18n.mityc.ts.error2"), (Throwable)e);
        }
        catch (IOException e) {
            throw new TimeStampException(I18N.getLocalMessage("i18n.mityc.ts.error2"), (Throwable)e);
        }
        try {
            tsv.setTimeStamRawToken(tst.toCMSSignedData().getEncoded());
        }
        catch (IOException e) {
            throw new TimeStampException(I18N.getLocalMessage("i18n.mityc.ts.error2"));
        }
        TimeStampTokenInfo tokenInfo = tst.getTimeStampInfo();
        MessageDigest resumen = TSPAlgoritmos.getDigest(tokenInfo.getMessageImprintAlgOID());
        if (resumen == null) {
            throw new TimeStampException(I18N.getLocalMessage("i18n.mityc.ts.validate.1", new Object[]{tokenInfo.getMessageImprintAlgOID()}));
        }
        resumen.update(sealedData);
        if (MessageDigest.isEqual(resumen.digest(), tst.getTimeStampInfo().getMessageImprintDigest())) {
            SimpleDateFormat formato = new SimpleDateFormat("dd/MM/yyyy H:mm:ss.SSS");
            tsv.setFormattedDate(formato.format(tokenInfo.getGenTime()));
            tsv.setDate(tokenInfo.getGenTime());
            GenTimeAccuracy precision = tokenInfo.getGenTimeAccuracy();
            long accuLong = 0L;
            if (precision != null) {
                accuLong = (long)precision.getMicros() * 1L + (long)precision.getMillis() * 1000L + (long)precision.getSeconds() * 1000000L;
            }
            tsv.setTimeAccurracy(accuLong);
            tsv.setStamp(tokenInfo.getSerialNumber());
            tsv.setSignDigest(new String(Base64Coder.encode((byte[])tokenInfo.getMessageImprintDigest())));
            tsv.setStampAlg(tokenInfo.getMessageImprintAlgOID());
            signer = null;
            GeneralName gn = tokenInfo.getTsa();
            if (gn != null && gn.getTagNo() == 4) {
                try {
                    signer = new X500Principal(X509Name.getInstance((Object)gn.getName()).getEncoded());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                CertStore cs = tst.getCertificatesAndCRLs("Collection", null);
                Collection<? extends Certificate> certs = cs.getCertificates(null);
                if (certs.size() > 0) {
                    tsv.setCadena(CertificateFactory.getInstance("X.509").generateCertPath(new ArrayList<Certificate>(certs)));
                    Certificate cert = certs.iterator().next();
                    if (signer == null && cert instanceof X509Certificate) {
                        signer = ((X509Certificate)cert).getSubjectX500Principal();
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        } else {
            throw new TimeStampException(I18N.getLocalMessage("i18n.mityc.ts.validate.2"));
        }
        tsv.setTimeStampIssuer(signer);
        return tsv;
    }
}

