/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.dniejava;

import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.CardNotPresentException;
import es.gob.jmulticard.apdu.connection.NoReadersFoundException;
import es.gob.jmulticard.card.AuthenticationModeLockedException;
import es.gob.jmulticard.card.CardException;
import es.gob.jmulticard.card.InvalidCardException;
import es.gob.jmulticard.jse.provider.DnieProvider;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.CertStoreException;
import es.mityc.javasign.pkstore.IPKStoreManager;
import es.mityc.javasign.pkstore.keystore.KSStore;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DNIeJavaStore
implements IPKStoreManager {
    private static final Log LOG = LogFactory.getLog(DNIeJavaStore.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibCert");
    private static final String DNI_KEYSTORE = "DNI";
    private static final String DNI_PROVIDER = "DNIeJCAProvider";
    private IPKStoreManager pkStore = null;

    public DNIeJavaStore() throws CertStoreException {
        try {
            DnieProvider p = new DnieProvider();
            Security.addProvider((Provider)p);
            KeyStore ks = KeyStore.getInstance(DNI_KEYSTORE);
            ks.load(null, null);
            this.pkStore = new KSStore(ks, null, "".toCharArray());
            if (LOG.isDebugEnabled()) {
                Iterator<Provider.Service> services = Security.getProvider(DNI_PROVIDER).getServices().iterator();
                LOG.debug((Object)"Servicios disponibles: ");
                while (services.hasNext()) {
                    Provider.Service ser = services.next();
                    LOG.debug((Object)ser);
                    LOG.debug((Object)("Algoritmo disponible: " + ser.getAlgorithm()));
                }
            }
        }
        catch (KeyStoreException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.dnie.1", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.dnie.1", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (CertificateException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.dnie.1", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (CardNotPresentException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.dnie.2", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (AuthenticationModeLockedException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.dnie.3", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (InvalidCardException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.dnie.4", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (NoReadersFoundException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.dnie.5", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (IllegalStateException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.dnie.6", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (CardException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.dnie.7", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (ApduConnectionException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.dnie.7", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.dnie.1", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
    }

    public Provider getProvider(X509Certificate cert) {
        return Security.getProvider(DNI_PROVIDER);
    }

    public CertPath getCertPath(X509Certificate certificate) throws CertStoreException {
        try {
            return this.pkStore != null ? this.pkStore.getCertPath(certificate) : null;
        }
        catch (AuthenticationModeLockedException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.dnie.3", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (ProviderException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.dnie.7", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
    }

    public PrivateKey getPrivateKey(X509Certificate certificate) throws CertStoreException {
        try {
            return this.pkStore != null ? this.pkStore.getPrivateKey(certificate) : null;
        }
        catch (AuthenticationModeLockedException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.dnie.3", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (ProviderException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.dnie.7", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
    }

    public List<X509Certificate> getSignCertificates() throws CertStoreException {
        try {
            return this.pkStore != null ? this.pkStore.getSignCertificates() : null;
        }
        catch (AuthenticationModeLockedException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.dnie.3", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (ProviderException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.dnie.7", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
    }

    public List<X509Certificate> getTrustCertificates() throws CertStoreException {
        try {
            return this.pkStore != null ? this.pkStore.getTrustCertificates() : null;
        }
        catch (AuthenticationModeLockedException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.dnie.3", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (ProviderException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.dnie.7", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
    }

    public List<X509Certificate> getPublicCertificates() throws CertStoreException {
        try {
            return this.pkStore != null ? this.pkStore.getPublicCertificates() : null;
        }
        catch (AuthenticationModeLockedException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.dnie.3", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (ProviderException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.dnie.7", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
    }
}

