/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.mozilla;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.CertStoreException;
import es.mityc.javasign.pkstore.IPKStoreManager;
import es.mityc.javasign.pkstore.mozilla.IPINDialogConfigurable;
import es.mityc.javasign.pkstore.mozilla.MozillaStoreUtils;
import es.mityc.javasign.utils.OSTool;
import iaik.pkcs.pkcs11.DefaultInitializeArgs;
import iaik.pkcs.pkcs11.InitializeArgs;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.PkProxyProvider;
import iaik.pkcs.pkcs11.PkcsProvider;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import java.io.File;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;
import org.mozilla.jss.util.PasswordCallbackInfo;

public class MozillaStorePKCS11
implements IPKStoreManager {
    private static final Log LOG = LogFactory.getLog(MozillaStorePKCS11.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibCert");
    private static Module cmNss = null;

    public MozillaStorePKCS11(String profile) throws CertStoreException {
        this(profile, MozillaStoreUtils.LIB_MODE.ONLY_PKCS11);
    }

    public MozillaStorePKCS11(String profile, MozillaStoreUtils.LIB_MODE mode) throws CertStoreException {
        if (cmNss == null) {
            this.initialize(profile, mode);
        }
    }

    public CertPath getCertPath(X509Certificate certificate) throws CertStoreException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public PrivateKey getPrivateKey(X509Certificate certificate) throws CertStoreException {
        if (cmNss != null) {
            try {
                Slot[] availSlots = cmNss.getSlotList(false);
                if (availSlots.length == 0) {
                    LOG.error((Object)"No se puede acceder a Firefox, no se han encontrado slots libres.");
                    return null;
                }
                int i = 0;
                while (i < availSlots.length) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Procesando slot " + i));
                    }
                    Token tok = availSlots[i].getToken();
                    Session sess = tok.openSession(true, false, null, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Session: " + sess.getSessionInfo()));
                    }
                    if (tok.getTokenInfo().isLoginRequired()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Solicitando contrase\u00f1a de acceso");
                        }
                        PasswordCallback passDialog = MozillaStoreUtils.getPassHandler(IPINDialogConfigurable.MESSAGES_MODE.AUTO_TOKEN, null, I18N.getLocalMessage("i18n.mityc.cert.mozilla.8"));
                        Password pass = passDialog.getPasswordFirstAttempt(new PasswordCallbackInfo("Firefox", 1));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"PIN obtenido, Autenticando");
                        }
                        try {
                            sess.login(true, pass.getCharCopy());
                        }
                        catch (Exception e) {
                            throw new CertStoreException("Contrase\u00f1a incorrecta", (Throwable)e);
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Resolviendo alias del certificado");
                    }
                    X509PublicKeyCertificate tempCert = new X509PublicKeyCertificate();
                    sess.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)tempCert);
                    iaik.pkcs.pkcs11.objects.Object[] foundCerts = sess.findObjects(100);
                    LOG.debug((Object)("Se han encontrado " + foundCerts.length + " certificados en el almac\u00e9n de Firefox"));
                    sess.findObjectsFinal();
                    String labelToFind = null;
                    int j = 0;
                    while (j < foundCerts.length) {
                        if (Arrays.equals(certificate.getIssuerX500Principal().getEncoded(), ((X509PublicKeyCertificate)foundCerts[j]).getIssuer().getByteArrayValue())) {
                            byte[] serialPkcs11 = ((X509PublicKeyCertificate)foundCerts[j]).getSerialNumber().getByteArrayValue();
                            serialPkcs11 = Arrays.copyOfRange(serialPkcs11, 2, serialPkcs11.length);
                            if (Arrays.equals(certificate.getSerialNumber().toByteArray(), serialPkcs11)) {
                                labelToFind = ((X509PublicKeyCertificate)foundCerts[j]).getLabel().toString();
                                break;
                            }
                        }
                        ++j;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Buscando clave privada asociada al alias " + labelToFind));
                    }
                    RSAPrivateKey tempKey = new RSAPrivateKey();
                    tempKey.getSign().setBooleanValue(Boolean.TRUE);
                    sess.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)tempKey);
                    iaik.pkcs.pkcs11.objects.Object[] foundKeys = sess.findObjects(100);
                    sess.findObjectsFinal();
                    LOG.debug((Object)("Encontradas " + foundKeys.length + " claves privadas"));
                    if (foundKeys != null && foundKeys.length > 0) {
                        int j2 = 0;
                        while (j2 < foundKeys.length) {
                            RSAPrivateKey tokenkey = (RSAPrivateKey)foundKeys[j2];
                            if (labelToFind.equals(new String(tokenkey.getLabel().getCharArrayValue()))) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)"Devolviendo pasarela a la clave privada");
                                }
                                return new PkProxyProvider(certificate, (iaik.pkcs.pkcs11.objects.PrivateKey)((RSAPrivateKey)foundKeys[j2]), sess);
                            }
                            ++j2;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Clave privada no encontrada");
                        }
                        return null;
                    }
                    ++i;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Clave privada no encontrada");
                }
                return null;
            }
            catch (Exception e) {
                throw new CertStoreException("No se pudo acceder al repositorio de certificados de Firefox", (Throwable)e);
            }
        }
        throw new CertStoreException("No se pudo acceder al repositorio de certificados de Firefox");
    }

    public Provider getProvider(X509Certificate cert) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Devolviendo instancia del proveedor criptogr\u00e1fico PKCS11Wrapper+NSS");
        }
        return new PkcsProvider();
    }

    public List<X509Certificate> getSignCertificates() throws CertStoreException {
        return this.getCertificates(true);
    }

    public List<X509Certificate> getPublicCertificates() throws CertStoreException {
        return this.getCertificates(false);
    }

    private List<X509Certificate> getCertificates(boolean getPrivates) throws CertStoreException {
        Slot[] availSlots;
        int foundCertsTotal;
        ArrayList<X509Certificate> allCertsPrivate;
        ArrayList<X509Certificate> allCertsPublic;
        block33: {
            if (cmNss == null) {
                LOG.error((Object)"No se ha cargado el m\u00f3dulo CSP-PKCS11 para Mozilla");
                throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mozilla.9"));
            }
            allCertsPublic = new ArrayList<X509Certificate>();
            allCertsPrivate = new ArrayList<X509Certificate>();
            foundCertsTotal = 0;
            availSlots = cmNss.getSlotList(false);
            if (availSlots.length != 0) break block33;
            LOG.error((Object)"No se puede acceder a Firefox, no se han encontrado slots libres.");
            return null;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Slots disponibles: " + availSlots.length));
            }
            int i = 0;
            while (i < availSlots.length) {
                block34: {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Procesando slot " + i));
                    }
                    Token tok = availSlots[i].getToken();
                    Session sess = tok.openSession(true, false, null, null);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Session: " + sess.getSessionInfo()));
                    }
                    if (tok.getTokenInfo().isLoginRequired()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Solicitando contrase\u00f1a de acceso");
                        }
                        PasswordCallback passDialog = MozillaStoreUtils.getPassHandler(IPINDialogConfigurable.MESSAGES_MODE.AUTO_TOKEN, null, I18N.getLocalMessage("i18n.mityc.cert.mozilla.8"));
                        Password pass = passDialog.getPasswordFirstAttempt(new PasswordCallbackInfo("Firefox", 1));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"PIN obtenido, Autenticando");
                        }
                        try {
                            sess.login(true, pass.getCharCopy());
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Contrase\u00f1a incorrecta", (Throwable)e);
                            break block34;
                        }
                    }
                    X509PublicKeyCertificate tempCert = new X509PublicKeyCertificate();
                    sess.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)tempCert);
                    iaik.pkcs.pkcs11.objects.Object[] foundCerts = sess.findObjects(100);
                    LOG.debug((Object)("Se han encontrado " + foundCerts.length + " certificados"));
                    foundCertsTotal += foundCerts.length;
                    sess.findObjectsFinal();
                    if (getPrivates) {
                        iaik.pkcs.pkcs11.objects.PrivateKey tempKey = new iaik.pkcs.pkcs11.objects.PrivateKey();
                        sess.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)tempKey);
                        iaik.pkcs.pkcs11.objects.Object[] privateKeys = sess.findObjects(100);
                        LOG.debug((Object)("Encontradas " + privateKeys.length + " claves privadas"));
                        sess.findObjectsFinal();
                        PublicKey tempKey2 = new PublicKey();
                        sess.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)tempKey2);
                        iaik.pkcs.pkcs11.objects.Object[] publicKeys = sess.findObjects(100);
                        LOG.debug((Object)("Encontradas " + publicKeys.length + " claves publicas"));
                        sess.findObjectsFinal();
                        int j = 0;
                        while (j < foundCerts.length) {
                            X509Certificate cert = MozillaStoreUtils.convert((X509PublicKeyCertificate)foundCerts[j]);
                            boolean[] usage = cert.getKeyUsage();
                            if (cert != null && (usage == null || usage[0] || usage[1])) {
                                if (!"RSA".equals(cert.getPublicKey().getAlgorithm())) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)("Encontrado certificado incompatible: " + cert.getSubjectDN().getName()));
                                        LOG.debug((Object)("Algoritmo incompatible de tipo: " + cert.getPublicKey().getAlgorithm()));
                                    }
                                } else {
                                    java.security.PublicKey pubKey = cert.getPublicKey();
                                    if (!(pubKey instanceof java.security.interfaces.RSAPublicKey)) {
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug((Object)("Encontrado certificado incompatible: " + cert.getSubjectDN().getName()));
                                            LOG.debug((Object)("Clave p\u00fablica incompatible de tipo: " + pubKey.getClass()));
                                        }
                                    } else {
                                        BigInteger moduloCert = ((java.security.interfaces.RSAPublicKey)pubKey).getModulus();
                                        BigInteger exponenteCert = ((java.security.interfaces.RSAPublicKey)pubKey).getPublicExponent();
                                        RSAPublicKey foundPublicKey = null;
                                        int k = 0;
                                        while (k < publicKeys.length) {
                                            String exponentePKHex;
                                            BigInteger exponentePK;
                                            String moduloPKHex;
                                            BigInteger moduloPK;
                                            if (publicKeys[k] != null && moduloCert.equals(moduloPK = new BigInteger(moduloPKHex = ((RSAPublicKey)publicKeys[k]).getModulus().toString(), 16)) && exponenteCert.equals(exponentePK = new BigInteger(exponentePKHex = ((RSAPublicKey)publicKeys[k]).getPublicExponent().toString(), 16))) {
                                                foundPublicKey = (RSAPublicKey)publicKeys[k];
                                                publicKeys[k] = null;
                                                break;
                                            }
                                            ++k;
                                        }
                                        if (foundPublicKey != null) {
                                            k = 0;
                                            while (k < privateKeys.length) {
                                                iaik.pkcs.pkcs11.objects.PrivateKey pk;
                                                if (privateKeys[k] != null && (pk = (iaik.pkcs.pkcs11.objects.PrivateKey)privateKeys[k]).getId() != null && pk.getId().equals((Object)foundPublicKey.getId())) {
                                                    if (LOG.isDebugEnabled()) {
                                                        LOG.debug((Object)"Se ha encontrado un certificado asociado a una clave privada presente");
                                                    }
                                                    privateKeys[k] = null;
                                                    allCertsPrivate.add(cert);
                                                    break;
                                                }
                                                ++k;
                                            }
                                        }
                                    }
                                }
                            }
                            ++j;
                        }
                    } else {
                        int j = 0;
                        while (j < foundCerts.length) {
                            X509Certificate cert = MozillaStoreUtils.convert((X509PublicKeyCertificate)foundCerts[j]);
                            allCertsPublic.add(cert);
                            ++j;
                        }
                    }
                }
                ++i;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Modulo P11 procesado");
            }
        }
        catch (Exception ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.9"), (Throwable)ex);
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mozilla.9"), (Throwable)ex);
        }
        if (getPrivates) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Se devuelven " + allCertsPrivate.size() + " certificados privados de un total de " + foundCertsTotal));
            }
            return allCertsPrivate;
        }
        return allCertsPublic;
    }

    public List<X509Certificate> getTrustCertificates() throws CertStoreException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private synchronized void initialize(String profile, MozillaStoreUtils.LIB_MODE mode) throws CertStoreException {
        String tmpDir = MozillaStoreUtils.initialize(profile, mode);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Se levanta el proveedor PKCS11Wrapper+NSS");
            }
            if (tmpDir != null && !tmpDir.endsWith(File.separator)) {
                tmpDir = String.valueOf(tmpDir) + File.separator;
            }
            if (OSTool.getSO().isMacOsX()) {
                MozillaStoreUtils.configureMacNSS(tmpDir);
            }
            cmNss = Module.getInstance((String)"softokn3.dll");
            DefaultInitializeArgs arguments = new DefaultInitializeArgs();
            byte[] stringBytes = null;
            stringBytes = MozillaStoreUtils.createPKCS11NSSConfigFile(profile, tmpDir).getBytes();
            byte[] reservedBytes = new byte[stringBytes.length + 5];
            System.arraycopy(stringBytes, 0, reservedBytes, 0, stringBytes.length);
            arguments.setReserved((Object)reservedBytes);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("M\u00f3dulo instanciado. Incializando con " + new String(stringBytes)));
            }
            cmNss.initialize((InitializeArgs)arguments);
        }
        catch (Throwable e) {
            LOG.error((Object)("No se pudo cargar la instancia de la librer\u00eda NSS: " + e.getMessage()), e);
        }
    }
}

