/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.mscapi.mityc;

import es.mityc.javasign.pkstore.mscapi.mityc.RSAKeyPair;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.UUID;

public final class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    static final int KEY_SIZE_MIN = 512;
    static final int KEY_SIZE_MAX = 16384;
    private static final int KEY_SIZE_DEFAULT = 1024;
    private int keySize;

    public RSAKeyPairGenerator() {
        this.initialize(1024, null);
    }

    @Override
    public void initialize(int keySize, SecureRandom random) {
        this.keySize = keySize;
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        int tmpSize;
        if (params == null) {
            tmpSize = 1024;
        } else if (params instanceof RSAKeyGenParameterSpec) {
            if (((RSAKeyGenParameterSpec)params).getPublicExponent() != null) {
                throw new InvalidAlgorithmParameterException("Exponent parameter is not supported");
            }
            tmpSize = ((RSAKeyGenParameterSpec)params).getKeysize();
        } else {
            throw new InvalidAlgorithmParameterException("Params must be an instance of RSAKeyGenParameterSpec");
        }
        this.keySize = tmpSize;
    }

    @Override
    public KeyPair generateKeyPair() {
        RSAKeyPair keys = RSAKeyPairGenerator.generateRSAKeyPair(this.keySize, "{" + UUID.randomUUID().toString() + "}");
        return new KeyPair(keys.getPublic(), keys.getPrivate());
    }

    private static native RSAKeyPair generateRSAKeyPair(int var0, String var1);
}

