/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.ocsp;

import es.mityc.firmaJava.ocsp.AuthenticatorProxyCredentials;
import es.mityc.firmaJava.ocsp.I18n;
import es.mityc.firmaJava.ocsp.RespuestaOCSP;
import es.mityc.firmaJava.ocsp.config.ConfigProveedores;
import es.mityc.firmaJava.ocsp.config.ServidorOcsp;
import es.mityc.firmaJava.ocsp.exception.OCSPClienteException;
import es.mityc.firmaJava.ocsp.exception.OCSPProxyException;
import es.mityc.javasign.certificate.ocsp.OwnSSLProtocolSocketFactory;
import es.mityc.javasign.ssl.ISSLManager;
import es.mityc.javasign.utils.Base64Coder;
import es.mityc.javasign.utils.ProxyUtil;
import es.mityc.javasign.utils.SimpleAuthenticator;
import es.mityc.javasign.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.ocsp.BasicOCSPResp;
import org.bouncycastle.ocsp.CertificateID;
import org.bouncycastle.ocsp.OCSPException;
import org.bouncycastle.ocsp.OCSPReq;
import org.bouncycastle.ocsp.OCSPReqGenerator;
import org.bouncycastle.ocsp.OCSPResp;
import org.bouncycastle.ocsp.RevokedStatus;
import org.bouncycastle.ocsp.SingleResp;
import org.bouncycastle.ocsp.UnknownStatus;

public class OCSPCliente {
    private static final Integer INT_20000 = new Integer(20000);
    private Integer timeOut = INT_20000;
    private String servidorURL;
    static Log log = LogFactory.getLog(OCSPCliente.class);
    private PostMethod method = null;
    private HttpClient client = null;

    public OCSPCliente(String servidorURL) {
        this.servidorURL = servidorURL;
    }

    public RespuestaOCSP validateCert(X509Certificate certificadoUsuario, X509Certificate certificadoEmisor) throws OCSPClienteException, OCSPProxyException {
        RespuestaOCSP respuesta = new RespuestaOCSP();
        Utils.addBCProvider();
        OCSPReqGenerator generadorPeticion = new OCSPReqGenerator();
        OCSPReq peticionOCSP = null;
        OCSPResp respuestaOCSP = null;
        CertificateID certificadoId = null;
        try {
            certificadoId = new CertificateID("1.3.14.3.2.26", certificadoEmisor, certificadoUsuario.getSerialNumber());
            log.info((Object)"Creado identificador \u00fanico de certificado a validar.");
        }
        catch (OCSPException e) {
            log.info((Object)("Error al generar el identificador unico del certificado de usuario: " + e.getMessage()));
            throw new OCSPClienteException(String.valueOf(I18n.getResource("libreriaocsp.error2")) + ": " + e.getMessage());
        }
        generadorPeticion.addRequest(certificadoId);
        try {
            peticionOCSP = generadorPeticion.generate();
            log.info((Object)"Petici\u00f3n OCSP generada.");
        }
        catch (OCSPException e) {
            log.error((Object)("Error al generar la petici\u00f3n OCSP: " + e.getMessage()));
            throw new OCSPClienteException(String.valueOf(I18n.getResource("libreriaocsp.error3")) + ": " + e.getMessage());
        }
        this.client = new HttpClient();
        if (System.getProperty("http.proxySet") != null && Boolean.parseBoolean(System.getProperty("http.proxySet")) && !ProxyUtil.isInNonHosts((String)this.servidorURL)) {
            UsernamePasswordCredentials defaultcreds;
            String encoded;
            if (System.getProperty("http.proxyUser") != null && !"".equals(System.getProperty("http.proxyUser"))) {
                Authenticator.setDefault((Authenticator)new SimpleAuthenticator(System.getProperty("http.proxyUser"), System.getProperty("http.proxyPassword")));
                encoded = new String(String.valueOf(System.getProperty("http.proxyUser")) + ":" + System.getProperty("http.proxyPassword"));
                defaultcreds = new UsernamePasswordCredentials(encoded);
                this.client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)defaultcreds);
            } else {
                Authenticator.setDefault(null);
                AuthenticatorProxyCredentials defaultcreds2 = new AuthenticatorProxyCredentials(System.getProperty("http.proxyHost"), "");
                this.client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)defaultcreds2);
            }
            this.client.getHostConfiguration().setProxy(System.getProperty("http.proxyHost"), Integer.parseInt(System.getProperty("http.proxyPort")));
            encoded = new String(String.valueOf(System.getProperty("http.proxyUser")) + ":" + System.getProperty("http.proxyPassword"));
            defaultcreds = new UsernamePasswordCredentials(encoded);
            this.client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)defaultcreds);
        }
        this.client.getParams().setParameter("http.socket.timeout", (Object)this.timeOut);
        this.client.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
        if (this.servidorURL == null || "".equals(this.servidorURL.trim()) || this.servidorURL.trim().equalsIgnoreCase("MULTIPLE")) {
            ServidorOcsp servidor = ConfigProveedores.getServidor(certificadoUsuario);
            if (servidor != null) {
                this.servidorURL = servidor.getUrl().toString();
                log.debug((Object)("Servidor OCSP encontrado " + this.servidorURL));
            } else {
                log.error((Object)I18n.getResource("libreriaocsp.error12"));
                this.servidorURL = "";
                throw new OCSPClienteException(I18n.getResource("libreriaocsp.error12"));
            }
        }
        this.method = new PostMethod(this.servidorURL);
        this.method.addRequestHeader("Content-Type", "application/ocsp-request");
        ByteArrayInputStream datos = null;
        try {
            datos = new ByteArrayInputStream(peticionOCSP.getEncoded());
        }
        catch (IOException e) {
            log.error((Object)("Error al leer la petici\u00f3n: " + e.getMessage()));
            throw new OCSPClienteException(String.valueOf(I18n.getResource("libreriaocsp.error4")) + ": " + e.getMessage());
        }
        InputStreamRequestEntity rq = new InputStreamRequestEntity((InputStream)datos);
        this.method.setRequestEntity((RequestEntity)rq);
        this.method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
        this.method.getParams().setParameter("http.socket.timeout", (Object)this.timeOut);
        MethodThread ocspThread = new MethodThread();
        ocspThread.start();
        try {
            try {
                byte[] cuerpoRespuesta;
                try {
                    ocspThread.join(this.timeOut.intValue());
                }
                catch (InterruptedException e) {
                    this.method.abort();
                    log.error((Object)"Error en la conexi\u00f3n con el servidor OCSP: Demanda de interrupci\u00f3n");
                    this.retryPost(0, peticionOCSP, ocspThread, datos.available());
                }
                int estadoCodigo = ocspThread.getResult();
                log.info((Object)"Petici\u00f3n enviada.");
                if (estadoCodigo != 200) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Respuesta de error: " + estadoCodigo));
                    }
                    this.retryPost(estadoCodigo, peticionOCSP, ocspThread, datos.available());
                }
                if ((cuerpoRespuesta = ocspThread.getResponse()) == null) {
                    String mensajeError = String.valueOf(I18n.getResource("libreriaocsp.error10")) + ": " + this.servidorURL;
                    log.error((Object)"Error en la conexi\u00f3n con el servidor OCSP: Respuesta vac\u00eda");
                    throw new OCSPClienteException(mensajeError);
                }
                log.info((Object)"Respuesta obtenida.");
                try {
                    respuestaOCSP = new OCSPResp(cuerpoRespuesta);
                }
                catch (IOException e) {
                    log.error((Object)("Error en la secuencia de bytes de respuesta: " + e.getMessage()));
                    throw new OCSPClienteException(String.valueOf(I18n.getResource("libreriaocsp.error5")) + ": " + e.getMessage());
                }
                OCSPCliente.processResponse(respuestaOCSP, respuesta, certificadoId);
            }
            catch (HttpException e) {
                log.error((Object)("Violaci\u00f3n del protocolo HTTP: " + e.getMessage()));
                throw new OCSPClienteException(String.valueOf(I18n.getResource("libreriaocsp.error7")) + ": " + e.getMessage());
            }
            catch (IOException e) {
                String mensajeError = String.valueOf(I18n.getResource("libreriaocsp.error10")) + ": " + this.servidorURL;
                log.error((Object)("Error en la conexi\u00f3n con el servidor OCSP: " + e.getMessage()));
                throw new OCSPClienteException(mensajeError);
            }
        }
        finally {
            Security.removeProvider("BC");
            this.method.releaseConnection();
        }
        return respuesta;
    }

    public static void processResponse(OCSPResp inResp, RespuestaOCSP outResp, CertificateID certID) throws OCSPClienteException, IOException {
        outResp.setRespuesta(inResp);
        if (inResp.getStatus() != 0) {
            log.info((Object)"OCSPResponseStatus: not successful.");
            switch (inResp.getStatus()) {
                case 1: {
                    log.warn((Object)"OCSPResponseStatus: malformedRequest.");
                    outResp.setNroRespuesta(4);
                    outResp.setMensajeRespuesta(I18n.getResource("libreriaocsp.respuesta1"));
                    break;
                }
                case 2: {
                    log.warn((Object)"OCSPResponseStatus: internalError.");
                    outResp.setNroRespuesta(5);
                    outResp.setMensajeRespuesta(I18n.getResource("libreriaocsp.respuesta2"));
                    break;
                }
                case 3: {
                    log.warn((Object)"OCSPResponseStatus: tryLater.");
                    outResp.setNroRespuesta(6);
                    outResp.setMensajeRespuesta(I18n.getResource("libreriaocsp.respuesta3"));
                    break;
                }
                case 5: {
                    log.warn((Object)"OCSPResponseStatus: sigRequired.");
                    outResp.setNroRespuesta(7);
                    outResp.setMensajeRespuesta(I18n.getResource("libreriaocsp.respuesta4"));
                    break;
                }
                case 6: {
                    log.warn((Object)"OCSPResponseStatus: unauthorized.");
                    outResp.setNroRespuesta(8);
                    outResp.setMensajeRespuesta(I18n.getResource("libreriaocsp.respuesta5"));
                }
            }
        } else {
            try {
                log.info((Object)"OCSPResponseStatus: successful.");
                BasicOCSPResp respuestaBasica = (BasicOCSPResp)inResp.getResponseObject();
                try {
                    X509Certificate[] certs = respuestaBasica.getCerts("SUN");
                    if (certs != null && certs.length > 0) {
                        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>(certs.length);
                        int i = 0;
                        while (i < certs.length) {
                            list.add(certs[i]);
                            ++i;
                        }
                        outResp.setOCSPSigner(list);
                    }
                }
                catch (NoSuchProviderException e) {
                    log.info((Object)e.getMessage(), (Throwable)e);
                }
                catch (OCSPException e) {
                    log.info((Object)e.getMessage(), (Throwable)e);
                }
                SingleResp[] arrayRespuestaBasica = respuestaBasica.getResponses();
                outResp.setTiempoRespuesta(respuestaBasica.getProducedAt());
                ResponderID respID = respuestaBasica.getResponderId().toASN1Object();
                outResp.setResponder(respID);
                StringBuffer mensaje = new StringBuffer("Se recibi\u00f3 un estado no definido: ");
                boolean finded = false;
                int i = 0;
                while (i < arrayRespuestaBasica.length) {
                    SingleResp sr = arrayRespuestaBasica[i];
                    if (certID.equals((Object)sr.getCertID())) {
                        finded = true;
                        Object certStatus = arrayRespuestaBasica[i].getCertStatus();
                        if (certStatus == null) {
                            log.info((Object)"Estado del certificado: Good.");
                            outResp.setNroRespuesta(0);
                            outResp.setMensajeRespuesta(new String(Base64Coder.encode((byte[])inResp.getEncoded())));
                        } else if (certStatus instanceof RevokedStatus) {
                            log.info((Object)"Estado del certificado: Revoked.");
                            outResp.setFechaRevocacion(((RevokedStatus)certStatus).getRevocationTime());
                            outResp.setNroRespuesta(1);
                            RevokedStatus revoked = (RevokedStatus)certStatus;
                            if (revoked.hasRevocationReason()) {
                                switch (revoked.getRevocationReason()) {
                                    case 1: {
                                        outResp.setMensajeRespuesta(I18n.getResource("libreriaocsp.razonrevocacion1"));
                                        break;
                                    }
                                    case 2: {
                                        outResp.setMensajeRespuesta(I18n.getResource("libreriaocsp.razonrevocacion2"));
                                        break;
                                    }
                                    case 3: {
                                        outResp.setMensajeRespuesta(I18n.getResource("libreriaocsp.razonrevocacion3"));
                                        break;
                                    }
                                    case 4: {
                                        outResp.setMensajeRespuesta(I18n.getResource("libreriaocsp.razonrevocacion4"));
                                        break;
                                    }
                                    case 5: {
                                        outResp.setMensajeRespuesta(I18n.getResource("libreriaocsp.razonrevocacion5"));
                                        break;
                                    }
                                    case 6: {
                                        outResp.setMensajeRespuesta(I18n.getResource("libreriaocsp.razonrevocacion6"));
                                        break;
                                    }
                                    default: {
                                        outResp.setMensajeRespuesta("");
                                        break;
                                    }
                                }
                            } else {
                                outResp.setMensajeRespuesta("");
                            }
                        } else if (certStatus instanceof UnknownStatus) {
                            log.info((Object)"Estado del certificado: Unknown.");
                            outResp.setNroRespuesta(2);
                            outResp.setMensajeRespuesta("El servidor ha respondido que el estado del certificado es desconocido");
                        } else {
                            mensaje.append(arrayRespuestaBasica[i].getCertStatus().getClass().getName());
                            log.info((Object)mensaje.toString());
                            outResp.setNroRespuesta(3);
                            outResp.setMensajeRespuesta(arrayRespuestaBasica[i].getCertStatus().getClass().getName());
                        }
                    }
                    ++i;
                }
                if (!finded) {
                    log.info((Object)"Estado del certificado: Unknown.");
                    outResp.setNroRespuesta(2);
                    outResp.setMensajeRespuesta("El servidor ha respondido que el estado del certificado es desconocido");
                }
            }
            catch (OCSPException e) {
                log.error((Object)("Error al instanciar la respuesta OCSP b\u00e1sica: " + e.getMessage()));
                throw new OCSPClienteException(String.valueOf(I18n.getResource("libreriaocsp.error6")) + ": " + e.getMessage());
            }
        }
    }

    public static void setSSLManager(ISSLManager sslmanager) {
        Protocol authhttps = new Protocol("https", (ProtocolSocketFactory)new OwnSSLProtocolSocketFactory(sslmanager), 443);
        Protocol.registerProtocol((String)"https", (Protocol)authhttps);
    }

    public void setTimeOut(Integer timeMilis) {
        if (timeMilis != null && timeMilis > 0) {
            log.debug((Object)("Se establece el tiempo m\u00e1ximo de espera a " + timeMilis));
            this.timeOut = timeMilis;
        } else {
            log.error((Object)("No se pudo establecer el valor de TimeOut a " + timeMilis + ". Se toma el valor por defecto."));
            this.timeOut = INT_20000;
        }
    }

    public synchronized void abort() {
        if (this.method != null) {
            this.method.abort();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void retryPost(int estadoCodigo, OCSPReq peticionOCSP, MethodThread ocspThread, int dataLenght) throws OCSPClienteException, OCSPProxyException {
        block23: {
            if (this.method == null || this.method.isAborted()) {
                log.debug((Object)"Cancelado por el usuario");
                return;
            }
            log.info((Object)"OCSP Satus: Reintentando v\u00eda HttpPOST");
            HttpURLConnection conn = null;
            InputStream in = null;
            try {
                try {
                    conn = ProxyUtil.getConnection((String)this.servidorURL);
                    conn.setConnectTimeout(7000);
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Content-Type", "application/ocsp-request");
                    conn.setRequestProperty("Accept", "application/ocsp-response");
                    conn.setRequestProperty("Content-Length", String.valueOf(dataLenght));
                    conn.setUseCaches(false);
                    conn.setDoOutput(true);
                    DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
                    wr.write(peticionOCSP.getEncoded());
                    wr.flush();
                    wr.close();
                    if (conn.getResponseCode() == 200) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Utilizando proxy: " + conn.usingProxy()));
                        }
                        in = (InputStream)conn.getContent();
                        OCSPResp ocspResponse = new OCSPResp(in);
                        int status = ocspResponse.getStatus();
                        if (ocspResponse != null && ocspResponse.getEncoded().length > 0) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Conexi\u00f3n satisfactoria v\u00eda HttpURLConnection");
                            }
                            estadoCodigo = 200;
                            ocspThread.setResponse(ocspResponse.getEncoded());
                            break block23;
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Se obtuvo una respuesta inesperada: " + status));
                            }
                            throw new OCSPClienteException(String.valueOf(I18n.getResource("libreriaocsp.error9")) + ": " + this.method.getStatusLine());
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Se obtuvo una respuesta de error:" + conn.getResponseCode() + " - " + conn.getResponseMessage()));
                    }
                }
                catch (Exception e1) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Conexi\u00f3n fallida v\u00eda HttpURLConnection", (Throwable)e1);
                    }
                    throw new OCSPProxyException(e1);
                }
            }
            finally {
                block24: {
                    if (conn != null) {
                        conn.disconnect();
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e1) {
                            if (!log.isDebugEnabled()) break block24;
                            log.debug((Object)"No se pudo cerrar el canal de escritura", (Throwable)e1);
                        }
                    }
                }
            }
        }
        if (estadoCodigo == 407) {
            throw new OCSPProxyException("Autenticaci\u00f3n fallida en el proxy");
        }
        if (estadoCodigo == 305) {
            throw new OCSPProxyException("Debe configurar su proxy para poder realizar la consulta");
        }
        if (estadoCodigo != 200) {
            log.error((Object)("Fallo la ejecuci\u00f3n del m\u00e9todo: " + this.method.getStatusLine()));
            throw new OCSPClienteException(String.valueOf(I18n.getResource("libreriaocsp.error9")) + ": " + this.method.getStatusLine());
        }
    }

    class MethodThread
    extends Thread {
        private int result = 0;
        private byte[] response = null;

        @Override
        public void run() {
            try {
                try {
                    this.result = OCSPCliente.this.client.executeMethod((HttpMethod)OCSPCliente.this.method);
                    this.response = OCSPCliente.this.method.getResponseBody();
                }
                catch (Exception e) {
                    log.error((Object)e);
                    OCSPCliente.this.method.releaseConnection();
                }
            }
            finally {
                OCSPCliente.this.method.releaseConnection();
            }
        }

        public int getResult() {
            return this.result;
        }

        public byte[] getResponse() {
            return this.response;
        }

        public void setResponse(byte[] res) {
            this.response = res;
        }
    }
}

