/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.ocsp.config;

import es.mityc.firmaJava.ocsp.config.ConstantesProveedores;
import es.mityc.firmaJava.ocsp.config.ServidorOcsp;
import es.mityc.firmaJava.ocsp.config.UtilidadesX509;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1OctetString;

public final class ProveedorInfo
implements Cloneable,
ConstantesProveedores {
    private static Log logger = LogFactory.getLog(ProveedorInfo.class);
    private String nombre = "";
    private String descripcion = "";
    private Hashtable<String, String> caHash = new Hashtable();
    private Vector<ServidorOcsp> servidores = new Vector();

    protected Object clone() throws CloneNotSupportedException {
        ProveedorInfo copy = (ProveedorInfo)super.clone();
        copy.nombre = this.nombre;
        copy.descripcion = this.descripcion;
        copy.caHash = new Hashtable();
        copy.caHash = this.getCAList();
        copy.servidores = new Vector();
        copy.servidores = this.getServidores();
        return copy;
    }

    public String getNombre() {
        return this.nombre;
    }

    protected void setNombre(String nombre) {
        this.nombre = nombre;
    }

    public String getDescripcion() {
        return this.descripcion;
    }

    protected void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public Vector<ServidorOcsp> getServidores() {
        Vector<ServidorOcsp> copy = null;
        int total2 = this.servidores.size();
        try {
            copy = new Vector<ServidorOcsp>();
            int i = 0;
            while (i < total2) {
                copy.add((ServidorOcsp)this.servidores.get(i).clone());
                ++i;
            }
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)e.getMessage());
        }
        return copy;
    }

    public ServidorOcsp getServidor() {
        Iterator<ServidorOcsp> lista = this.getServidores().iterator();
        ServidorOcsp servidorOcsp = null;
        if (lista.hasNext()) {
            servidorOcsp = lista.next();
        }
        return servidorOcsp;
    }

    protected Hashtable<String, String> getCAList() {
        return (Hashtable)this.caHash.clone();
    }

    public boolean puedeValidar(Object certObj) {
        X509Certificate cert;
        block8: {
            cert = null;
            if (certObj == null) {
                logger.error((Object)"Illegal argument type. Can be a String, byte[] or X509Certificate.");
                return false;
            }
            try {
                if (certObj instanceof String) {
                    cert = UtilidadesX509.getCertificate((String)certObj);
                    break block8;
                }
                if (certObj instanceof byte[]) {
                    cert = UtilidadesX509.getCertificate((byte[])certObj);
                    break block8;
                }
                if (certObj instanceof X509Certificate) {
                    cert = (X509Certificate)certObj;
                    break block8;
                }
                logger.error((Object)"Illegal argument type. Can be a String, byte[] or X509Certificate.");
                return false;
            }
            catch (CertificateException e) {
                logger.error((Object)e.getMessage());
                return false;
            }
        }
        String nameHash = "";
        String pkHash = "";
        try {
            ASN1OctetString issuerNameHash = UtilidadesX509.getIssuerNameHash(cert);
            ASN1OctetString issuerKeyHash = UtilidadesX509.getIssuerKeyHash(cert);
            nameHash = issuerNameHash.toString().replace("#", "");
            pkHash = issuerKeyHash.toString().replace("#", "");
            return this.puedeValidar(nameHash, pkHash);
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            return false;
        }
    }

    protected boolean puedeValidar(String nameHash, String pkHash) {
        if (this.caHash.containsKey(nameHash)) {
            return this.caHash.get(nameHash).equals(pkHash);
        }
        return false;
    }

    protected void addServidor(ServidorOcsp server) {
        this.servidores.add(server);
    }

    protected void addCA(String nameHash, String pkHash) {
        if (UtilidadesX509.isEmpty(nameHash)) {
            return;
        }
        if (!this.caHash.containsKey(nameHash)) {
            this.caHash.put(nameHash, pkHash);
        }
    }
}

