/*
 * Decompiled with CFR 0.152.
 */
package adsi.org.apache.xml.security.keys.keyresolver.implementations;

import adsi.org.apache.xml.security.exceptions.XMLSecurityException;
import adsi.org.apache.xml.security.keys.content.X509Data;
import adsi.org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import adsi.org.apache.xml.security.keys.keyresolver.KeyResolverException;
import adsi.org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import adsi.org.apache.xml.security.keys.storage.StorageResolver;
import adsi.org.apache.xml.security.signature.XMLSignatureException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class X509IssuerSerialResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog((String)X509IssuerSerialResolver.class.getName());

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        X509Certificate cert = this.engineLookupResolveX509Certificate(element, BaseURI, storage);
        if (cert != null) {
            return cert.getPublicKey();
        }
        return null;
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Can I resolve " + element.getTagName() + "?"));
        }
        X509Data x509data = null;
        try {
            x509data = new X509Data(element, BaseURI);
        }
        catch (XMLSignatureException ex) {
            log.debug((Object)"I can't");
            return null;
        }
        catch (XMLSecurityException ex) {
            log.debug((Object)"I can't");
            return null;
        }
        if (x509data == null) {
            log.debug((Object)"I can't");
            return null;
        }
        if (!x509data.containsIssuerSerial()) {
            return null;
        }
        try {
            if (storage == null) {
                Object[] exArgs = new Object[]{"X509IssuerSerial"};
                KeyResolverException ex = new KeyResolverException("KeyResolver.needStorageResolver", exArgs);
                log.info((Object)"", (Throwable)ex);
                throw ex;
            }
            int noOfISS = x509data.lengthIssuerSerial();
            while (storage.hasNext()) {
                X509Certificate cert = storage.next();
                XMLX509IssuerSerial certSerial = new XMLX509IssuerSerial(element.getOwnerDocument(), cert);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found Certificate Issuer: " + certSerial.getIssuerName()));
                    log.debug((Object)("Found Certificate Serial: " + certSerial.getSerialNumber().toString()));
                }
                int i = 0;
                while (i < noOfISS) {
                    XMLX509IssuerSerial xmliss = x509data.itemIssuerSerial(i);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found Element Issuer:     " + xmliss.getIssuerName()));
                        log.debug((Object)("Found Element Serial:     " + xmliss.getSerialNumber().toString()));
                    }
                    if (certSerial.equals(xmliss)) {
                        log.debug((Object)"match !!! ");
                        return cert;
                    }
                    log.debug((Object)"no match...");
                    ++i;
                }
            }
            return null;
        }
        catch (XMLSecurityException ex) {
            log.debug((Object)"XMLSecurityException", (Throwable)ex);
            throw new KeyResolverException("generic.EmptyMessage", ex);
        }
    }

    @Override
    public SecretKey engineLookupAndResolveSecretKey(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }
}

