/*
 * Decompiled with CFR 0.152.
 */
package adsi.org.apache.xml.security.transforms.implementations;

import adsi.org.apache.xml.security.signature.NodeFilter;
import adsi.org.apache.xml.security.utils.XMLUtils;
import java.util.Set;
import org.w3c.dom.Node;

class XPath2NodeFilter
implements NodeFilter {
    boolean hasUnionNodes;
    boolean hasSubstractNodes;
    boolean hasIntersectNodes;
    Set unionNodes;
    Set substractNodes;
    Set intersectNodes;
    int inSubstract = -1;
    int inIntersect = -1;
    int inUnion = -1;

    XPath2NodeFilter(Set unionNodes, Set substractNodes, Set intersectNodes) {
        this.unionNodes = unionNodes;
        this.hasUnionNodes = !unionNodes.isEmpty();
        this.substractNodes = substractNodes;
        this.hasSubstractNodes = !substractNodes.isEmpty();
        this.intersectNodes = intersectNodes;
        this.hasIntersectNodes = !intersectNodes.isEmpty();
    }

    @Override
    public int isNodeInclude(Node currentNode) {
        int result = 1;
        if (this.hasSubstractNodes && XPath2NodeFilter.rooted(currentNode, this.substractNodes)) {
            result = -1;
        } else if (this.hasIntersectNodes && !XPath2NodeFilter.rooted(currentNode, this.intersectNodes)) {
            result = 0;
        }
        if (result == 1) {
            return 1;
        }
        if (this.hasUnionNodes) {
            if (XPath2NodeFilter.rooted(currentNode, this.unionNodes)) {
                return 1;
            }
            result = 0;
        }
        return result;
    }

    @Override
    public int isNodeIncludeDO(Node n, int level) {
        int result = 1;
        if (this.hasSubstractNodes) {
            if (this.inSubstract == -1 || level <= this.inSubstract) {
                this.inSubstract = XPath2NodeFilter.inList(n, this.substractNodes) ? level : -1;
            }
            if (this.inSubstract != -1) {
                result = -1;
            }
        }
        if (result != -1 && this.hasIntersectNodes && (this.inIntersect == -1 || level <= this.inIntersect)) {
            if (!XPath2NodeFilter.inList(n, this.intersectNodes)) {
                this.inIntersect = -1;
                result = 0;
            } else {
                this.inIntersect = level;
            }
        }
        if (level <= this.inUnion) {
            this.inUnion = -1;
        }
        if (result == 1) {
            return 1;
        }
        if (this.hasUnionNodes) {
            if (this.inUnion == -1 && XPath2NodeFilter.inList(n, this.unionNodes)) {
                this.inUnion = level;
            }
            if (this.inUnion != -1) {
                return 1;
            }
            result = 0;
        }
        return result;
    }

    static boolean rooted(Node currentNode, Set nodeList) {
        if (nodeList.contains(currentNode)) {
            return true;
        }
        for (Node rootNode : nodeList) {
            if (!XMLUtils.isDescendantOrSelf(rootNode, currentNode)) continue;
            return true;
        }
        return false;
    }

    static boolean inList(Node currentNode, Set nodeList) {
        return nodeList.contains(currentNode);
    }
}

