/*
 * Decompiled with CFR 0.152.
 */
package adsi.org.apache.xml.security.transforms.params;

import adsi.org.apache.xml.security.exceptions.XMLSecurityException;
import adsi.org.apache.xml.security.transforms.TransformParam;
import adsi.org.apache.xml.security.utils.ElementProxy;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InclusiveNamespaces
extends ElementProxy
implements TransformParam {
    public static final String _TAG_EC_INCLUSIVENAMESPACES = "InclusiveNamespaces";
    public static final String _ATT_EC_PREFIXLIST = "PrefixList";
    public static final String ExclusiveCanonicalizationNamespace = "http://www.w3.org/2001/10/xml-exc-c14n#";

    public InclusiveNamespaces(Document doc, String prefixList) {
        this(doc, InclusiveNamespaces.prefixStr2Set(prefixList));
    }

    public InclusiveNamespaces(Document doc, Set prefixes) {
        super(doc);
        StringBuffer sb = new StringBuffer();
        TreeSet prefixList = new TreeSet(prefixes);
        for (String prefix : prefixList) {
            if (prefix.equals("xmlns")) {
                sb.append("#default ");
                continue;
            }
            sb.append(String.valueOf(prefix) + " ");
        }
        this._constructionElement.setAttributeNS(null, _ATT_EC_PREFIXLIST, sb.toString().trim());
    }

    public String getInclusiveNamespaces() {
        return this._constructionElement.getAttributeNS(null, _ATT_EC_PREFIXLIST);
    }

    public InclusiveNamespaces(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
    }

    public static SortedSet prefixStr2Set(String inclusiveNamespaces) {
        TreeSet<String> prefixes = new TreeSet<String>();
        if (inclusiveNamespaces == null || inclusiveNamespaces.length() == 0) {
            return prefixes;
        }
        StringTokenizer st = new StringTokenizer(inclusiveNamespaces, " \t\r\n");
        while (st.hasMoreTokens()) {
            String prefix = st.nextToken();
            if (prefix.equals("#default")) {
                prefixes.add("xmlns");
                continue;
            }
            prefixes.add(prefix);
        }
        return prefixes;
    }

    @Override
    public String getBaseNamespace() {
        return ExclusiveCanonicalizationNamespace;
    }

    @Override
    public String getBaseLocalName() {
        return _TAG_EC_INCLUSIVENAMESPACES;
    }
}

