/*
 * Decompiled with CFR 0.152.
 */
package adsi.org.apache.xml.security.utils;

import adsi.org.apache.xml.security.algorithms.SignatureAlgorithm;
import adsi.org.apache.xml.security.signature.XMLSignatureException;
import java.io.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SignerOutputStream
extends ByteArrayOutputStream {
    static final byte[] none = "error".getBytes();
    final SignatureAlgorithm sa;
    static Log log = LogFactory.getLog((String)SignerOutputStream.class.getName());

    public SignerOutputStream(SignatureAlgorithm sa) {
        this.sa = sa;
    }

    @Override
    public byte[] toByteArray() {
        return none;
    }

    @Override
    public void write(byte[] arg0) {
        try {
            this.sa.update(arg0);
        }
        catch (XMLSignatureException e) {
            throw new RuntimeException("" + e);
        }
    }

    @Override
    public void write(int arg0) {
        try {
            this.sa.update((byte)arg0);
        }
        catch (XMLSignatureException e) {
            throw new RuntimeException("" + e);
        }
    }

    @Override
    public void write(byte[] arg0, int arg1, int arg2) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Canonicalized SignedInfo:");
            StringBuffer sb = new StringBuffer(arg2);
            int i = arg1;
            while (i < arg1 + arg2) {
                sb.append((char)arg0[i]);
                ++i;
            }
            log.debug((Object)sb.toString());
        }
        try {
            this.sa.update(arg0, arg1, arg2);
        }
        catch (XMLSignatureException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"", (Throwable)e);
            }
            throw new RuntimeException("" + e);
        }
    }
}

