/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.SignatureProperty;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMSignatureProperty
extends DOMStructure
implements SignatureProperty {
    private final String id;
    private final String target;
    private final List content;

    public DOMSignatureProperty(List content, String target, String id) {
        if (target == null) {
            throw new NullPointerException("target cannot be null");
        }
        if (content == null) {
            throw new NullPointerException("content cannot be null");
        }
        if (content.isEmpty()) {
            throw new IllegalArgumentException("content cannot be empty");
        }
        ArrayList contentCopy = new ArrayList(content);
        int i = 0;
        int size = contentCopy.size();
        while (i < size) {
            if (!(contentCopy.get(i) instanceof XMLStructure)) {
                throw new ClassCastException("content[" + i + "] is not a valid type");
            }
            ++i;
        }
        this.content = Collections.unmodifiableList(contentCopy);
        this.target = target;
        this.id = id;
    }

    public DOMSignatureProperty(Element propElem) throws MarshalException {
        this.target = DOMUtils.getAttributeValue(propElem, "Target");
        if (this.target == null) {
            throw new MarshalException("target cannot be null");
        }
        this.id = DOMUtils.getAttributeValue(propElem, "Id");
        NodeList nodes = propElem.getChildNodes();
        int length = nodes.getLength();
        ArrayList<javax.xml.crypto.dom.DOMStructure> content = new ArrayList<javax.xml.crypto.dom.DOMStructure>(length);
        int i = 0;
        while (i < length) {
            content.add(new javax.xml.crypto.dom.DOMStructure(nodes.item(i)));
            ++i;
        }
        if (content.isEmpty()) {
            throw new MarshalException("content cannot be empty");
        }
        this.content = Collections.unmodifiableList(content);
    }

    @Override
    public List getContent() {
        return this.content;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public void marshal(Node parent, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element propElem = DOMUtils.createElement(ownerDoc, "SignatureProperty", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        DOMUtils.setAttributeID(propElem, "Id", this.id);
        DOMUtils.setAttribute(propElem, "Target", this.target);
        int i = 0;
        int size = this.content.size();
        while (i < size) {
            javax.xml.crypto.dom.DOMStructure property = (javax.xml.crypto.dom.DOMStructure)this.content.get(i);
            DOMUtils.appendChild(propElem, property.getNode());
            ++i;
        }
        parent.appendChild(propElem);
    }

    public boolean equals(Object o) {
        boolean idsEqual;
        if (this == o) {
            return true;
        }
        if (!(o instanceof SignatureProperty)) {
            return false;
        }
        SignatureProperty osp = (SignatureProperty)o;
        boolean bl = this.id == null ? osp.getId() == null : (idsEqual = this.id.equals(osp.getId()));
        return this.equalsContent(osp.getContent()) && this.target.equals(osp.getTarget()) && idsEqual;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 50;
    }

    private boolean equalsContent(List otherContent) {
        int osize = otherContent.size();
        if (this.content.size() != osize) {
            return false;
        }
        int i = 0;
        while (i < osize) {
            XMLStructure oxs = (XMLStructure)otherContent.get(i);
            XMLStructure xs = (XMLStructure)this.content.get(i);
            if (oxs instanceof javax.xml.crypto.dom.DOMStructure) {
                if (!(xs instanceof javax.xml.crypto.dom.DOMStructure)) {
                    return false;
                }
                Node onode = ((javax.xml.crypto.dom.DOMStructure)oxs).getNode();
                Node node = ((javax.xml.crypto.dom.DOMStructure)xs).getNode();
                if (!DOMUtils.nodesEqual(node, onode)) {
                    return false;
                }
            } else if (!xs.equals(oxs)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

