/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.xml.xades.policy.age;

import es.mityc.firmaJava.libreria.utilidades.UtilidadTratarNodo;
import es.mityc.firmaJava.libreria.xades.DatosFirma;
import es.mityc.firmaJava.libreria.xades.DatosNodosFirmados;
import es.mityc.firmaJava.libreria.xades.ResultadoValidacion;
import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.DigestAlgAndValueType;
import es.mityc.firmaJava.libreria.xades.elementos.xades.IPolicyQualifier;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SPURI;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SigPolicyHash;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SigPolicyId;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SigPolicyQualifier;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SigPolicyQualifiers;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SignaturePolicyIdentifier;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import es.mityc.firmaJava.libreria.xades.errores.PolicyException;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.trust.TrustAbstract;
import es.mityc.javasign.trust.TrustException;
import es.mityc.javasign.trust.TrustFactory;
import es.mityc.javasign.xml.xades.TransformProxy;
import es.mityc.javasign.xml.xades.policy.IFirmaPolicy;
import es.mityc.javasign.xml.xades.policy.IValidacionPolicy;
import es.mityc.javasign.xml.xades.policy.PoliciesTool;
import es.mityc.javasign.xml.xades.policy.UnknownPolicyException;
import es.mityc.javasign.xml.xades.policy.age.ConfigAGE;
import es.mityc.javasign.xml.xades.policy.age.ConfigAgeException;
import java.io.IOException;
import java.io.InputStream;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AgeManager
implements IValidacionPolicy,
IFirmaPolicy {
    private static final Log LOG = LogFactory.getLog(AgeManager.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibPolicy");
    private static final String CONFIG_FILENAME = "age.properties";
    protected static final String URI_ID_POLICY = "text:{0}";
    protected static final String UTF_8 = "UTF-8";
    private static Properties rb = null;
    protected TrustAbstract truster = TrustFactory.getInstance().getTruster("mityc");

    static {
        try {
            InputStream is = AgeManager.class.getResourceAsStream(CONFIG_FILENAME);
            if (is != null) {
                rb = new Properties();
                rb.load(is);
            } else {
                LOG.error((Object)"No se encontr\u00f3 configuraci\u00f3n sobre pol\u00edticas");
            }
        }
        catch (IOException ex) {
            LOG.fatal((Object)I18N.getLocalMessage("i18n.mityc.policy.general.12"), (Throwable)ex);
        }
    }

    protected AgeManager() throws InstantiationException {
        if (this.truster == null) {
            throw new InstantiationException(I18N.getLocalMessage("i18n.mityc.policy.general.29"));
        }
    }

    protected static ConfigAGE loadConfig(String prefix) throws ConfigAgeException {
        if (rb == null) {
            throw new ConfigAgeException(I18N.getLocalMessage("i18n.mityc.policy.general.13"));
        }
        return new ConfigAGE(rb, prefix);
    }

    private DigestAlgAndValueType getDigestRelated(String algorithm) {
        DigestAlgAndValueType daavt = null;
        for (DigestAlgAndValueType temp : this.getConfig().getHuellas()) {
            if (!temp.getDigestMethod().getAlgorithm().equals(algorithm)) continue;
            daavt = temp;
            break;
        }
        return daavt;
    }

    protected void checkPolicyHash(Element signatureNode, ResultadoValidacion rs) throws PolicyException {
        XAdESSchemas schema = rs.getDatosFirma().getEsquema();
        if (schema == null) {
            throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.general.25"));
        }
        String esquema = schema.getSchemaUri();
        NodeList signaturePolicyList = signatureNode.getElementsByTagNameNS(esquema, "SignaturePolicyIdentifier");
        if (signaturePolicyList.getLength() != 1) {
            throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.general.26"));
        }
        if (signaturePolicyList.item(0).getNodeType() != 1) {
            throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.general.26"));
        }
        try {
            SignaturePolicyIdentifier signaturePolicyIdentifier = new SignaturePolicyIdentifier(schema);
            if (!signaturePolicyIdentifier.isThisNode(signaturePolicyList.item(0))) {
                throw new InvalidInfoNodeException(I18N.getLocalMessage("i18n.mityc.policy.general.14"));
            }
            signaturePolicyIdentifier.load((Element)signaturePolicyList.item(0));
            if (signaturePolicyIdentifier.isImplied()) {
                throw new InvalidInfoNodeException(I18N.getLocalMessage("i18n.mityc.policy.general.15"));
            }
            DigestAlgAndValueType value = this.getDigestRelated(signaturePolicyIdentifier.getSignaturePolicyId().getSigPolicyHash().getDigestMethod().getAlgorithm());
            SignaturePolicyIdentifier comp = this.createPolicy(schema, value);
            if (!signaturePolicyIdentifier.equals((Object)comp)) {
                throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.general.27"));
            }
        }
        catch (InvalidInfoNodeException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)I18N.getLocalMessage("i18n.mityc.policy.general.16"), (Throwable)ex);
            }
            throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.general.28", new Object[]{ex.getMessage()}));
        }
    }

    protected void checkNodes(Element signatureNode, ResultadoValidacion rs) throws PolicyException {
        NodeList nl = null;
        boolean hasTime = false;
        boolean hasCert = false;
        boolean hasFormat = false;
        nl = signatureNode.getElementsByTagName("SigningTime");
        if (nl != null) {
            hasTime = true;
        }
        if ((nl = signatureNode.getElementsByTagName("SigningCertificate")) != null) {
            hasCert = true;
        }
        if ((nl = signatureNode.getElementsByTagName("DataObjectFormat")) != null) {
            hasFormat = true;
        }
        if (hasTime && hasCert && hasFormat) {
            return;
        }
        throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.age.2"));
    }

    protected void checkCertificateInKeyInfoNode(Element signatureNode, ResultadoValidacion rs) throws UnknownPolicyException, PolicyException {
        List nodos = rs.getDatosFirma().getDatosNodosFirmados();
        for (DatosNodosFirmados nodo : nodos) {
            Element el;
            String id = nodo.getId();
            if (id == null || (el = UtilidadTratarNodo.getElementById((Document)signatureNode.getOwnerDocument(), (String)id)) == null || !"http://www.w3.org/2000/09/xmldsig#".equals(el.getNamespaceURI()) || !"KeyInfo".equals(el.getLocalName()) || !el.getParentNode().equals(signatureNode)) continue;
            List trans = nodo.getTransforms();
            for (TransformProxy transform : trans) {
                if (TransformProxy.isCanonicalization((TransformProxy)transform)) continue;
                throw new UnknownPolicyException(I18N.getLocalMessage("i18n.mityc.policy.age.4"));
            }
            return;
        }
        throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.general.30"));
    }

    protected void checkRoles(Element signatureNode, ResultadoValidacion rs) throws PolicyException {
    }

    protected void checkTimestamp(Element signatureNode, ResultadoValidacion rs) throws PolicyException {
    }

    protected void checkStatusCertificate(Element signatureNode, ResultadoValidacion rs) throws PolicyException {
    }

    protected void checkTrustSigningCertificate(Element signatureNode, ResultadoValidacion rs) throws PolicyException {
        DatosFirma df = rs.getDatosFirma();
        if (df != null) {
            try {
                this.truster.isTrusted((Object)df.getCadenaFirma());
            }
            catch (TrustException ex) {
                throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.age.1"));
            }
        } else {
            throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.general.20"));
        }
    }

    protected void checkTrustTsa(Element signatureNode, ResultadoValidacion rs) throws PolicyException {
    }

    protected SignaturePolicyIdentifier createPolicy(XAdESSchemas schema, DigestAlgAndValueType value) throws InvalidInfoNodeException {
        if (value == null) {
            throw new InvalidInfoNodeException(I18N.getLocalMessage("i18n.mityc.policy.general.17"));
        }
        ConfigAGE config = this.getConfig();
        SignaturePolicyIdentifier resultado = new SignaturePolicyIdentifier(schema, false);
        resultado.getSignaturePolicyId().setSigPolicyId(new SigPolicyId(schema, config.getPolicyIdXades(), config.getPolicyDescription()));
        resultado.getSignaturePolicyId().setSigPolicyHash(new SigPolicyHash(schema, value));
        ArrayList<SigPolicyQualifier> lista = new ArrayList<SigPolicyQualifier>();
        SPURI spUri = new SPURI(schema, config.getSpUri());
        spUri.setNamespaceXAdES(value.getNamespaceXAdES());
        lista.add(new SigPolicyQualifier(schema, (IPolicyQualifier)spUri));
        SigPolicyQualifiers qualifiers = new SigPolicyQualifiers(schema, lista);
        resultado.getSignaturePolicyId().setSigPolicyQualifiers(qualifiers);
        return resultado;
    }

    public void escribePolicy(Element signatureNode, String namespaceDS, String namespaceXAdES, XAdESSchemas schema) throws PolicyException {
        SignaturePolicyIdentifier spi;
        ConfigAGE config = this.getConfig();
        try {
            if (config.getPolicyWriterId() < 0 || config.getPolicyWriterId() >= config.getHuellas().size()) {
                throw new InvalidInfoNodeException(I18N.getLocalMessage("i18n.mityc.policy.general.18"));
            }
            DigestAlgAndValueType hash = config.getHuellas().get(config.getPolicyWriterId());
            hash.setNamespaceXAdES(namespaceXAdES);
            spi = this.createPolicy(schema, hash);
        }
        catch (InvalidInfoNodeException ex) {
            throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.general.19"));
        }
        PoliciesTool.insertPolicyNode((Element)signatureNode, (String)namespaceDS, (String)namespaceXAdES, (XAdESSchemas)schema, (SignaturePolicyIdentifier)spi);
    }

    protected static String getFormatedMessage(String message, Object ... varargs) {
        MessageFormat mf = new MessageFormat(message);
        return mf.format(varargs, new StringBuffer(), (FieldPosition)null).toString();
    }

    protected abstract ConfigAGE getConfig();
}

