/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.xml.xades.policy.facturae;

import es.mityc.firmaJava.libreria.utilidades.URIEncoder;
import es.mityc.firmaJava.libreria.xades.DatosFirma;
import es.mityc.firmaJava.libreria.xades.ResultadoValidacion;
import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.errores.PolicyException;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.trust.TrustAbstract;
import es.mityc.javasign.xml.xades.policy.PolicyResult;
import es.mityc.javasign.xml.xades.policy.UnknownPolicyException;
import es.mityc.javasign.xml.xades.policy.facturae.ConfigFacturae;
import es.mityc.javasign.xml.xades.policy.facturae.ConfigFacturaeException;
import es.mityc.javasign.xml.xades.policy.facturae.FacturaeManager;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class Facturae31Manager
extends FacturaeManager {
    private static final Log LOG = LogFactory.getLog(Facturae31Manager.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibPolicy");
    private static final String PREFIX_POLICY_PROP = "facturae31";
    private static ConfigFacturae config = null;

    static {
        try {
            config = FacturaeManager.loadConfig(PREFIX_POLICY_PROP);
        }
        catch (ConfigFacturaeException ex) {
            LOG.fatal((Object)I18N.getLocalMessage("i18n.mityc.policy.general.7"), (Throwable)((Object)ex));
        }
    }

    public Facturae31Manager() throws InstantiationException {
        if (config == null) {
            throw new InstantiationException(I18N.getLocalMessage("i18n.mityc.policy.general.8"));
        }
    }

    @Override
    protected ConfigFacturae getConfig() {
        return config;
    }

    public String getIdentidadPolicy() {
        return config.getPolicyIdValidador();
    }

    public PolicyResult validaPolicy(Element nodoFirma, ResultadoValidacion resultadoValidacion) {
        PolicyResult pr = new PolicyResult();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Validando pol\u00edtica de factura 3.1");
        }
        try {
            URI id = config.getPolicyIdXades();
            try {
                id = new URI(Facturae31Manager.getFormatedMessage("text:{0}", URIEncoder.encode((String)config.getPolicyIdValidador(), (String)"UTF-8")));
            }
            catch (URISyntaxException ex) {
                LOG.warn((Object)I18N.getLocalMessage("i18n.mityc.policy.general.9"), (Throwable)ex);
            }
            catch (UnsupportedEncodingException ex) {
                LOG.warn((Object)I18N.getLocalMessage("i18n.mityc.policy.general.9"), (Throwable)ex);
            }
            pr.setPolicyID(id);
            pr.setDownloable(new PolicyResult.DownloadPolicy[]{pr.newDownloadPolicy(config.getPolicyIdXades(), PolicyResult.StatusValidation.unknown)});
            this.checkSchema(nodoFirma, resultadoValidacion);
            this.checkPolicyHash(nodoFirma, resultadoValidacion);
            this.checkEnveloped(nodoFirma, resultadoValidacion);
            this.checkCertificateInKeyInfoNode(nodoFirma, resultadoValidacion);
            this.checkRoles(nodoFirma, resultadoValidacion);
            this.checkTimestamp(nodoFirma, resultadoValidacion);
            this.checkStatusCertificate(nodoFirma, resultadoValidacion);
            this.checkTrustSigningCertificate(nodoFirma, resultadoValidacion);
            this.checkTrustTsa(nodoFirma, resultadoValidacion);
            pr.setResult(PolicyResult.StatusValidation.valid);
        }
        catch (UnknownPolicyException ex) {
            pr.setResult(PolicyResult.StatusValidation.unknown);
            pr.setDescriptionResult(ex.getMessage());
        }
        catch (PolicyException ex) {
            pr.setResult(PolicyResult.StatusValidation.invalid);
            pr.setDescriptionResult(ex.getMessage());
        }
        return pr;
    }

    protected void checkSchema(Element nodoFirma, ResultadoValidacion rs) throws PolicyException {
        DatosFirma df = rs.getDatosFirma();
        if (df != null) {
            XAdESSchemas schema = df.getEsquema();
            if (!XAdESSchemas.XAdES_122.equals((Object)schema) && !XAdESSchemas.XAdES_132.equals((Object)schema)) {
                throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.general.24"));
            }
        } else {
            throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.general.23"));
        }
    }

    public void writePolicyNode(Element nodoFirma, String namespaceDS, String namespaceXAdES, XAdESSchemas schema) throws PolicyException {
        this.escribePolicy(nodoFirma, namespaceDS, namespaceXAdES, schema);
    }

    public void setTruster(TrustAbstract truster) {
        if (truster != null) {
            this.truster = truster;
        }
    }
}

