/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;

class P11Util {
    private static Object LOCK = new Object();
    private static volatile Provider sun;
    private static volatile Provider sunRsaSign;
    private static volatile Provider sunJce;

    private P11Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Provider getSunProvider() {
        Provider provider = sun;
        if (provider == null) {
            Object object = LOCK;
            synchronized (object) {
                sun = provider = P11Util.getProvider(sun, "SUN", "sun.security.provider.Sun");
            }
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Provider getSunRsaSignProvider() {
        Provider provider = sunRsaSign;
        if (provider == null) {
            Object object = LOCK;
            synchronized (object) {
                sunRsaSign = provider = P11Util.getProvider(sunRsaSign, "SunRsaSign", "sun.security.rsa.SunRsaSign");
            }
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Provider getSunJceProvider() {
        Provider provider = sunJce;
        if (provider == null) {
            Object object = LOCK;
            synchronized (object) {
                sunJce = provider = P11Util.getProvider(sunJce, "SunJCE", "com.sun.crypto.provider.SunJCE");
            }
        }
        return provider;
    }

    private static Provider getProvider(Provider provider, String string, String string2) {
        if (provider != null) {
            return provider;
        }
        provider = Security.getProvider(string);
        if (provider == null) {
            try {
                Class<?> clazz = Class.forName(string2);
                provider = (Provider)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new ProviderException("Could not find provider " + string, exception);
            }
        }
        return provider;
    }

    static byte[] convert(byte[] byArray, int n, int n2) {
        if (n == 0 && n2 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    static byte[] subarray(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    static byte[] concat(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }
}

