/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.crypto.asymetric;

import es.mityc.crypto.CryptoManager;
import es.mityc.crypto.Utils;
import es.mityc.crypto.symetric.TripleDESManager;
import es.mityc.javasign.utils.Base64Coder;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.IEKeySpec;
import org.bouncycastle.jce.spec.IESParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.encoders.Hex;

public class EllipticCurveManager
implements CryptoManager {
    static Log logger = LogFactory.getLog(EllipticCurveManager.class);
    private static final int keySize = 4096;
    private static byte[] salt = SecureRandom.getSeed(8);
    private Cipher ecCipher = null;
    private SecureRandom random = null;
    private TripleDESManager simetricCipher = null;

    public EllipticCurveManager() {
        this.init();
    }

    @Override
    public void feedSeed(byte[] seed) {
        this.random.nextBytes(salt);
        if (seed != null) {
            int i = 0;
            while (i < salt.length && i < seed.length) {
                EllipticCurveManager.salt[i] = (byte)(salt[i] & seed[i]);
                ++i;
            }
        }
        this.random.setSeed(salt);
    }

    private void init() throws SecurityException {
        if (Security.getProvider("BC") == null) {
            es.mityc.javasign.utils.Utils.addBCProvider();
        }
        try {
            this.ecCipher = Cipher.getInstance("ECIES", "BC");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException("No se pudo instanciar el algoritmo EC", e);
        }
        catch (NoSuchProviderException e) {
            throw new SecurityException("No se encontr\u00f3 el proveedor de BouncyCastle", e);
        }
        catch (NoSuchPaddingException e) {
            throw new SecurityException("No se pudo inicializar el relleno", e);
        }
        this.random = new SecureRandom(salt);
    }

    public char[] protectEC(String plain, Key key) throws SecurityException {
        if (key == null || plain == null) {
            throw new SecurityException("Faltan par\u00e1metros de entrada");
        }
        try {
            this.ecCipher.init(1, key, this.random);
            byte[] cipherText = this.ecCipher.doFinal(plain.getBytes());
            return Base64Coder.encode((byte[])cipherText);
        }
        catch (InvalidKeyException ex) {
            throw new SecurityException(ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new SecurityException(ex);
        }
        catch (BadPaddingException ex) {
            throw new SecurityException(ex);
        }
    }

    public byte[] recoverEC(char[] cryptedText, Key key) throws SecurityException {
        if (key == null || cryptedText == null) {
            throw new SecurityException("Faltan par\u00e1metros de entrada");
        }
        try {
            this.ecCipher.init(2, key);
            byte[] ciphertext = this.ecCipher.doFinal(Base64Coder.decode((Object)cryptedText));
            return ciphertext;
        }
        catch (InvalidKeyException ex) {
            throw new SecurityException(ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new SecurityException(ex);
        }
        catch (BadPaddingException ex) {
            throw new SecurityException("Clave incorrecta", ex);
        }
    }

    public String genNewECKeys(String password) {
        try {
            ECCurve.Fp curva = new ECCurve.Fp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839"), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
            ECParameterSpec ecSpec = new ECParameterSpec((ECCurve)curva, curva.decodePoint(Hex.decode((String)"020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"));
            KeyPairGenerator generator = KeyPairGenerator.getInstance("ECIES", "BC");
            generator.initialize(192, this.random);
            KeyPair newKeys = generator.generateKeyPair();
            try {
                PrivateKey privateKey = newKeys.getPrivate();
                PublicKey publicaKey = newKeys.getPublic();
                System.out.println("Clave privada " + privateKey.toString());
                System.out.println("Clave publica " + publicaKey.toString());
                newKeys = generator.generateKeyPair();
                PrivateKey priKey = newKeys.getPrivate();
                PublicKey pubKey = newKeys.getPublic();
                Cipher cifrador = Cipher.getInstance("ECIES", "BC");
                IEKeySpec c1Key = new IEKeySpec(privateKey, pubKey);
                IEKeySpec c2Key = new IEKeySpec(priKey, publicaKey);
                byte[] d = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
                byte[] e = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
                IESParameterSpec param = new IESParameterSpec(d, e, 128);
                cifrador.init(1, (Key)c1Key, (AlgorithmParameterSpec)param);
                byte[] mensajeCifrado = cifrador.doFinal("123456".getBytes());
                System.out.println("Mensaje Cifrado: " + mensajeCifrado);
                cifrador.init(2, (Key)c2Key, (AlgorithmParameterSpec)param);
                byte[] mensajeRecuperado = cifrador.doFinal(mensajeCifrado);
                System.out.println("Mensaje Recuperado: " + new String(mensajeRecuperado));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            byte[] pbcBuffer = newKeys.getPublic().getEncoded();
            byte[] pvtBuffer = newKeys.getPrivate().getEncoded();
            int totalSize = pbcBuffer.length + pvtBuffer.length + 4;
            byte[] pairData = new byte[totalSize];
            char[] pubSize = String.valueOf(pbcBuffer.length).toCharArray();
            int i = 0;
            while (i < pubSize.length) {
                pairData[i] = (byte)pubSize[i];
                ++i;
            }
            i = 0;
            while (i < pbcBuffer.length) {
                pairData[i + 4] = pbcBuffer[i];
                ++i;
            }
            i = pbcBuffer.length + 4;
            while (i < totalSize) {
                pairData[i] = pvtBuffer[i - (pbcBuffer.length + 4)];
                ++i;
            }
            if (this.simetricCipher == null) {
                this.simetricCipher = new TripleDESManager();
            }
            char[] encPairChar = this.simetricCipher.protectTripleDES(pairData, password);
            return new String(encPairChar);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
        catch (NoSuchProviderException e) {
            throw new SecurityException(e);
        }
    }

    public KeyPair unprotectKeyPair(String encPair, String password) throws SecurityException {
        return this.unprotectKeyPair(encPair.toCharArray(), password);
    }

    public KeyPair unprotectKeyPair(char[] encPairChar, String password) throws SecurityException {
        if (this.simetricCipher == null) {
            this.simetricCipher = new TripleDESManager();
        }
        byte[] pair = this.simetricCipher.recoverTripleDES(encPairChar, password);
        int pubKeySize = 0;
        int cifra = 0;
        int i = 0;
        while (i < 4) {
            block10: {
                try {
                    cifra = Integer.valueOf(String.valueOf((char)pair[i]));
                    if (cifra < 0 || cifra > 9) break block10;
                    pubKeySize = pubKeySize * 10 + cifra;
                }
                catch (NumberFormatException e) {
                    break;
                }
            }
            ++i;
        }
        byte[] publicKeyData = new byte[pubKeySize];
        byte[] privateKeyData = new byte[pair.length - pubKeySize - 4];
        int i2 = 4;
        while (i2 < pubKeySize + 4) {
            publicKeyData[i2 - 4] = pair[i2];
            ++i2;
        }
        i2 = pubKeySize + 4;
        while (i2 < pair.length) {
            privateKeyData[i2 - (pubKeySize + 4)] = pair[i2];
            ++i2;
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(privateKeyData);
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicKeyData);
            return new KeyPair(keyFactory.generatePublic(publicKeySpec), keyFactory.generatePrivate(privateKeySpec));
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new SecurityException(e);
        }
        catch (NoSuchProviderException e) {
            throw new SecurityException(e);
        }
    }

    @Override
    public String getUsedAlgorithmURI() {
        return this.ecCipher.getAlgorithm();
    }

    public static void main(String[] args) {
        String plain = "TextoEnClaro0123456789";
        EllipticCurveManager p = new EllipticCurveManager();
        System.out.println("Se solicita el c\u00e1lculo de un nuevo par de claves asim\u00e9tricas de 4096 bits");
        Long start = System.currentTimeMillis();
        String protectedPair = p.genNewECKeys("123456789012345678901234");
        KeyPair pair = p.unprotectKeyPair(protectedPair, "123456789012345678901234");
        Long time = System.currentTimeMillis() - start;
        System.out.println("Claves obtenidas. Tiempo consumido (ms): " + time + ". Comienzan las pruebas de encriptaci\u00f3n...");
        System.out.println("Texto en claro: " + plain);
        String buffer = plain;
        char[] bufferChar = p.protectEC(buffer, pair.getPrivate());
        buffer = new String(bufferChar);
        System.out.println("Texto encriptado RSA con privada: " + buffer);
        buffer = new String(p.recoverEC(bufferChar, pair.getPublic()));
        System.out.println("Texto desencriptado RSA con p\u00fablica: " + buffer);
        start = System.currentTimeMillis();
        buffer = Utils.obfuscate(new String(p.protectEC(buffer, pair.getPublic())));
        System.out.println("Encriptado RSA con p\u00fablica y ofuscado: " + buffer);
        buffer = new String(p.recoverEC(Utils.undoObfuscate(buffer.getBytes()).toCharArray(), pair.getPrivate()));
        time = System.currentTimeMillis() - start;
        System.out.println("Texto recuperado con privada: " + buffer + "\nTiempo consumido (ms): " + time);
    }
}

