/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.crypto.steganography;

import es.mityc.crypto.Utils;
import es.mityc.crypto.steganography.StegoConfig;
import es.mityc.crypto.steganography.StegoUtils;

public class CabeceraLSB {
    protected static final byte[] SELLO = "STEGANOGRAFIADA".getBytes();
    public static final int ESPACIO_RESERVADO = 8;
    private int datosLength = 0;
    private int bitsCanalUtilizados = 0;
    private byte[] fileName = null;
    private StegoConfig config = null;

    public CabeceraLSB(int datosLength, int bitsUtilizados, String fileName, StegoConfig config) {
        this.datosLength = datosLength;
        this.bitsCanalUtilizados = bitsUtilizados;
        this.config = config;
        if (fileName == null) {
            this.fileName = "datos.bin".getBytes();
        } else {
            try {
                this.fileName = fileName.getBytes("UTF-8");
            }
            catch (Exception unEx) {
                this.fileName = fileName.getBytes();
            }
        }
    }

    public CabeceraLSB() {
    }

    public byte[] getDatosCabecera(byte[] pass) {
        byte[] out = null;
        int stampLen = 0;
        int currIndex = 0;
        byte[] dataStamp = SELLO;
        byte[] finalFileName = this.fileName;
        if (pass != null && pass.length > 0) {
            dataStamp = Utils.obfuscate(new String(dataStamp), StegoUtils.hashPassLong(new String(pass))).getBytes();
            finalFileName = Utils.obfuscate(new String(this.fileName), StegoUtils.hashPassLong(new String(pass))).getBytes();
        }
        stampLen = SELLO.length;
        out = new byte[stampLen + 8 + finalFileName.length];
        System.arraycopy(dataStamp, 0, out, currIndex, stampLen);
        currIndex += stampLen;
        out[currIndex++] = (byte)(this.datosLength & 0xFF);
        out[currIndex++] = (byte)((this.datosLength & 0xFF00) >> 8);
        out[currIndex++] = (byte)((this.datosLength & 0xFF0000) >> 16);
        out[currIndex++] = (byte)((this.datosLength & 0xFF000000) >> 32);
        out[currIndex++] = (byte)this.bitsCanalUtilizados;
        out[currIndex++] = (byte)finalFileName.length;
        out[currIndex++] = (byte)(this.config.isComprimir() ? 1 : 0);
        out[currIndex++] = (byte)(this.config.isEncriptar() ? 1 : 0);
        if (finalFileName.length > 0) {
            System.arraycopy(finalFileName, 0, out, currIndex, finalFileName.length);
            currIndex += finalFileName.length;
        }
        return out;
    }

    public int getBitsUtilizados() {
        return this.bitsCanalUtilizados;
    }

    public void setBitsUtilizados(int bitsUtilizados) {
        this.bitsCanalUtilizados = bitsUtilizados;
    }

    public int getLongitudDatos() {
        return this.datosLength;
    }

    public String getFileName() {
        String name = null;
        try {
            name = new String(this.fileName, "UTF-8");
        }
        catch (Exception e) {
            name = new String(this.fileName);
        }
        return name;
    }

    public void setFileName(byte[] fileName) {
        this.fileName = fileName;
    }

    public int getLongitudCabecera() {
        return SELLO.length + 8 + this.fileName.length;
    }

    public static int getLongMaxCabecera() {
        return SELLO.length + 8 + 256;
    }
}

