/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.crypto.steganography;

import es.mityc.crypto.Utils;
import es.mityc.crypto.steganography.CabeceraLSB;
import es.mityc.crypto.steganography.StegoConfig;
import es.mityc.crypto.steganography.StegoException;
import es.mityc.crypto.steganography.StegoUtils;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StegoData {
    static Log logger = LogFactory.getLog(StegoData.class);
    private BufferedImage image = null;
    private Random rand = null;
    private static final int BUF_SIZE = 512;
    private int imgWidth = 0;
    private int imgHeight = 0;
    private int channelBitsUsed = 1;
    private CabeceraLSB header = null;
    private boolean[][][][] matrizMaestra;
    private int[][] matrizDebug;
    private BufferedImage imageDebug = null;
    protected StegoConfig config = new StegoConfig();

    public byte[] extraerDatos(File imagen, String password) throws Exception {
        InputStream is = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int bytesRead = 0;
        byte[] data = new byte[512];
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Leyendo imagen estaganografiada");
            }
            is = new FileInputStream(imagen);
            while ((bytesRead = is.read(data, 0, 512)) >= 0) {
                bos.write(data, 0, bytesRead);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
        finally {
            block11: {
                try {
                    is.close();
                    bos.close();
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block11;
                    logger.debug((Object)e);
                }
            }
        }
    }

    public byte[] extraerDatos(byte[] img, String password) throws Exception {
        this.rand = new Random(StegoUtils.hashPassLong(password));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extrayendo datos");
        }
        this.header = new CabeceraLSB();
        return this.getEmbeddedData(img, password != null ? password.getBytes() : null);
    }

    public byte[] getStegoFileName() {
        return this.header.getFileName().getBytes();
    }

    private byte[] getEmbeddedData(byte[] cover, byte[] password) throws Exception {
        this.image = StegoUtils.byteArrayToImage(cover);
        if (this.image == null) {
            throw new Exception("No se pudo leer la imagen.");
        }
        this.imgWidth = this.image.getWidth();
        this.imgHeight = this.image.getHeight();
        this.matrizMaestra = new boolean[this.imgWidth][this.imgHeight][3][this.config.getMaxBitsPorCanal()];
        int i = 0;
        while (i < this.imgWidth) {
            int j = 0;
            while (j < this.imgHeight) {
                int k = 0;
                while (k < this.config.getMaxBitsPorCanal()) {
                    this.matrizMaestra[i][j][0][k] = false;
                    this.matrizMaestra[i][j][1][k] = false;
                    this.matrizMaestra[i][j][2][k] = false;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return this.getBytes(cover, password);
    }

    private byte[] getBytes(byte[] b, byte[] pass) throws IOException {
        return this.getBytes(b, 0, pass);
    }

    private byte[] getBytes(byte[] b, int off, byte[] password) throws IOException {
        if (b == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Byte de entrada nulo");
            }
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Posici\u00f3n fuera de rango");
            }
            throw new IndexOutOfBoundsException();
        }
        if (this.image == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No se pudo leer la imagen de entrada");
            }
            return null;
        }
        ByteArrayInputStream bais = null;
        try {
            boolean founded = false;
            int i = 0;
            int cabeceraLength = CabeceraLSB.SELLO.length + 8;
            byte[] res = null;
            byte[] stamp = new byte[CabeceraLSB.SELLO.length];
            int j = 1;
            while (j < this.config.getMaxBitsPorCanal()) {
                this.rand = new Random(StegoUtils.hashPassLong(password != null ? new String(password) : null));
                this.matrizMaestra = new boolean[this.imgWidth][this.imgHeight][3][this.config.getMaxBitsPorCanal()];
                int k = 0;
                while (k < this.imgWidth) {
                    int h = 0;
                    while (h < this.imgHeight) {
                        int l = 0;
                        while (l < this.config.getMaxBitsPorCanal()) {
                            this.matrizMaestra[k][h][0][l] = false;
                            this.matrizMaestra[k][h][1][l] = false;
                            this.matrizMaestra[k][h][2][l] = false;
                            ++l;
                        }
                        ++h;
                    }
                    ++k;
                }
                i = 0;
                this.channelBitsUsed = j;
                res = new byte[cabeceraLength];
                while (i < cabeceraLength) {
                    res[i] = (byte)this.getPixelByte(b[off + i]);
                    ++i;
                }
                bais = new ByteArrayInputStream(res);
                bais.read(stamp, 0, CabeceraLSB.SELLO.length);
                if (!new String(stamp).equals(new String(CabeceraLSB.SELLO))) {
                    String msg;
                    if (password != null && password.length > 0 && new String(msg = Utils.undoObfuscate(stamp, StegoUtils.hashPassLong(new String(password)))).equals(new String(CabeceraLSB.SELLO))) {
                        founded = true;
                        break;
                    }
                } else {
                    founded = true;
                    break;
                }
                ++j;
            }
            if (!founded) {
                throw new StegoException("No se encuentra la cabecera");
            }
            byte[] headerBytes = new byte[8];
            bais.read(headerBytes, 0, 8);
            int dataLength = StegoUtils.byteToInt(headerBytes[0]) + (StegoUtils.byteToInt(headerBytes[1]) << 8) + (StegoUtils.byteToInt(headerBytes[2]) << 16) + (StegoUtils.byteToInt(headerBytes[3]) << 32);
            byte fileNameLen = headerBytes[5];
            this.config.setComprimir(headerBytes[6] == 1);
            this.config.setEncriptar(headerBytes[7] == 1);
            res = new byte[fileNameLen];
            cabeceraLength = fileNameLen + cabeceraLength;
            int j2 = 0;
            while (i < cabeceraLength) {
                res[j2] = (byte)this.getPixelByte(b[off + i]);
                ++j2;
                ++i;
            }
            if (password != null && password.length > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Desencriptando " + stamp.length + " bytes"));
                }
                try {
                    res = Utils.undoObfuscate(res, StegoUtils.hashPassLong(new String(password))).getBytes();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            this.header.setFileName(res);
            if (dataLength == 0 || dataLength > b.length) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Longitud de entrada nula o fuera de rango");
                }
                return null;
            }
            res = new byte[dataLength];
            dataLength += cabeceraLength;
            j = 0;
            while (i < dataLength) {
                res[j] = (byte)this.getPixelByte(b[off + i]);
                ++j;
                ++i;
            }
            byte[] byArray = res;
            return byArray;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new IOException(e);
        }
        finally {
            block35: {
                try {
                    bais.close();
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block35;
                    logger.debug((Object)e);
                }
            }
        }
    }

    private int getPixelByte(int data) throws IOException {
        int x = 0;
        int y = 0;
        int channel = 0;
        int bit = 0;
        byte[] bitSet = new byte[8];
        int i = 0;
        while (i < 8) {
            while (this.matrizMaestra[x = this.rand.nextInt(this.imgWidth)][y = this.rand.nextInt(this.imgHeight)][channel = this.rand.nextInt(3)][bit = this.rand.nextInt(this.channelBitsUsed)]) {
            }
            this.matrizMaestra[x][y][channel][bit] = true;
            bitSet[i] = (byte)this.getPixelBit(x, y, channel, bit);
            ++i;
        }
        return (bitSet[0] << 7) + (bitSet[1] << 6) + (bitSet[2] << 5) + (bitSet[3] << 4) + (bitSet[4] << 3) + (bitSet[5] << 2) + (bitSet[6] << 1) + (bitSet[7] << 0);
    }

    private int getPixelBit(int x, int y, int channel, int bit) {
        return this.image.getRGB(x, y) >> channel * 8 + bit & 1;
    }

    public byte[] embeberDatos(byte[] datos, String nombreDatos, byte[] img, String pathImg, String password) throws StegoException {
        this.rand = new Random(StegoUtils.hashPassLong(password));
        try {
            this.image = StegoUtils.byteArrayToImage(img);
            this.imgWidth = this.image.getWidth();
            this.imgHeight = this.image.getHeight();
            if (logger.isDebugEnabled()) {
                this.imageDebug = StegoUtils.byteArrayToImage(img);
            }
        }
        catch (Exception e) {
            logger.error((Object)"No se pudo leer la imagen indicada", (Throwable)e);
            throw new StegoException(e);
        }
        if (this.image.getColorModel() instanceof IndexColorModel) {
            logger.error((Object)"No se pueden utilizar imagenes con colores indexados");
            throw new StegoException("No se pueden utilizar imagenes con colores indexados");
        }
        this.inicializar();
        try {
            if (nombreDatos != null) {
                this.write(this.crearCabecera(datos.length, nombreDatos, password != null ? password.getBytes() : null));
            } else {
                int noOfPixels = this.imgWidth * this.imgHeight;
                int dataLength = datos.length;
                while ((double)(noOfPixels * 3 * this.channelBitsUsed) / 8.0 < (double)dataLength) {
                    if (++this.channelBitsUsed <= this.config.getMaxBitsPorCanal()) continue;
                    throw new StegoException("Datos demasiado grandes para embeber");
                }
            }
            this.write(datos);
            String formatoDestino = pathImg.substring(pathImg.lastIndexOf(46) + 1);
            return StegoUtils.imageToByteArray(this.image, formatoDestino);
        }
        catch (StegoException soEx) {
            throw soEx;
        }
        catch (Exception e) {
            logger.error((Object)"No se pudo embeber los datos en la imagen indicada", (Throwable)e);
            throw new StegoException(e);
        }
    }

    private byte[] crearCabecera(int dataLength, String fileName, byte[] pass) throws StegoException {
        int noOfPixels = this.imgWidth * this.imgHeight;
        int headerSize = 0;
        try {
            this.header = new CabeceraLSB(dataLength, this.channelBitsUsed, fileName, this.config);
            headerSize = this.header.getLongitudCabecera();
            while ((double)(noOfPixels * 3 * this.channelBitsUsed) / 8.0 < (double)(headerSize + dataLength)) {
                if (++this.channelBitsUsed <= this.config.getMaxBitsPorCanal()) continue;
                throw new StegoException("Datos demasiado grandes para embeber");
            }
            this.header.setBitsUtilizados(this.channelBitsUsed);
            return this.header.getDatosCabecera(pass);
        }
        catch (StegoException soEx) {
            throw soEx;
        }
        catch (Exception ex) {
            throw new StegoException(ex);
        }
    }

    private void inicializar() throws StegoException {
        int j;
        this.matrizMaestra = new boolean[this.imgWidth][this.imgHeight][3][this.config.getMaxBitsPorCanal()];
        int i = 0;
        while (i < this.imgWidth) {
            j = 0;
            while (j < this.imgHeight) {
                int k = 0;
                while (k < this.channelBitsUsed) {
                    this.matrizMaestra[i][j][0][k] = false;
                    this.matrizMaestra[i][j][1][k] = false;
                    this.matrizMaestra[i][j][2][k] = false;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (logger.isDebugEnabled()) {
            this.matrizDebug = new int[this.imgWidth][this.imgHeight];
            i = 0;
            while (i < this.imgWidth) {
                j = 0;
                while (j < this.imgHeight) {
                    this.matrizDebug[i][j] = 0;
                    ++j;
                }
                ++i;
            }
        }
    }

    private void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    private void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Byte de entrada nulo");
            }
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Posici\u00f3n fuera de rango");
            }
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Longitud de entrada nula");
            }
            return;
        }
        if (this.image == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No se pudo leer la imagen de entrada");
            }
            return;
        }
        int i = 0;
        while (i < len) {
            this.write(b[off + i]);
            ++i;
        }
    }

    private void write(int data) throws IOException {
        boolean bitValue = false;
        int x = 0;
        int y = 0;
        int channel = 0;
        int bit = 0;
        int i = 0;
        while (i < 8) {
            boolean bl = bitValue = (data >> 7 - i & 1) == 1;
            while (this.matrizMaestra[x = this.rand.nextInt(this.imgWidth)][y = this.rand.nextInt(this.imgHeight)][channel = this.rand.nextInt(3)][bit = this.rand.nextInt(this.channelBitsUsed)]) {
            }
            this.matrizMaestra[x][y][channel][bit] = true;
            this.setPixelBit(x, y, channel, bit, bitValue);
            ++i;
        }
    }

    private void setPixelBit(int x, int y, int channel, int bit, boolean bitValue) {
        int pixel = 0;
        int newPixel = 0;
        pixel = this.image.getRGB(x, y);
        if (bitValue) {
            newPixel = pixel | 1 << bit + channel * 8;
        } else {
            int newColor = -2;
            int i = 0;
            while (i < bit + channel * 8) {
                newColor = newColor << 1 | 1;
                ++i;
            }
            newPixel = pixel & newColor;
        }
        this.image.setRGB(x, y, newPixel);
        if (logger.isDebugEnabled() && this.imageDebug != null) {
            if (this.imageDebug.getRGB(x, y) != newPixel) {
                this.matrizDebug[x][y] = newPixel;
            } else if (this.matrizDebug[x][y] != 0) {
                this.matrizDebug[x][y] = 0;
            }
        }
    }
}

