/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.crypto.steganography;

import es.mityc.crypto.steganography.CabeceraLSB;
import es.mityc.crypto.steganography.StegoConfig;
import es.mityc.crypto.steganography.StegoData;
import es.mityc.crypto.steganography.StegoException;
import es.mityc.crypto.steganography.StegoUtils;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StegoSign {
    static Log logger = LogFactory.getLog(StegoSign.class);
    private BufferedImage image = null;
    private Random rand = null;
    private static final int BUF_SIZE = 512;
    private int imgWidth = 0;
    private int imgHeight = 0;
    private int channelBitsUsed = 1;
    private CabeceraLSB cabecera = null;
    private String fileName = null;
    private boolean[][][][] matrizMaestra;
    private static StegoConfig config = new StegoConfig();

    public byte[] getRestaurationData(File imagenOriginal, File datos, String password) throws Exception {
        this.rand = new Random(StegoUtils.hashPassLong(password));
        InputStream is = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteArrayOutputStream bosFirma = new ByteArrayOutputStream();
        int bytesRead = 0;
        byte[] data = new byte[512];
        try {
            byte[] datosZip;
            block16: {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Leyendo imagen original");
                }
                is = new FileInputStream(imagenOriginal);
                while ((bytesRead = is.read(data, 0, 512)) >= 0) {
                    bos.write(data, 0, bytesRead);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Leyendo datos a ocultar");
                }
                is = new FileInputStream(datos);
                while ((bytesRead = is.read(data, 0, 512)) >= 0) {
                    bosFirma.write(data, 0, bytesRead);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Calculando datos de recuperaci\u00f3n");
                }
                datosZip = null;
                try {
                    datosZip = StegoUtils.zipData(bosFirma.toByteArray());
                    datosZip = new byte[datosZip.length + 50];
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block16;
                    logger.debug((Object)"Se contin\u00faa sin comprimir");
                }
            }
            byte[] byArray = this.getRestoreData(datosZip, datos.getName(), bos.toByteArray(), password != null ? password.getBytes() : null);
            return byArray;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
        finally {
            block17: {
                try {
                    is.close();
                    bos.close();
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block17;
                    logger.debug((Object)e);
                }
            }
        }
    }

    public void restoreOriginal(File imagen, byte[] restaurationData, File destino, String password) throws Exception {
        InputStream is = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int bytesRead = 0;
        byte[] data = new byte[512];
        try {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Leyendo imagen original");
                }
                is = new FileInputStream(imagen);
                while ((bytesRead = is.read(data, 0, 512)) >= 0) {
                    bos.write(data, 0, bytesRead);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Restaurando imagen");
                }
                byte[] res = new StegoData().embeberDatos(restaurationData, null, bos.toByteArray(), imagen.getName(), password);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Escribiendo el resultado");
                }
                BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(destino));
                fos.write(res);
                fos.flush();
                fos.close();
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw e;
            }
        }
        finally {
            block14: {
                try {
                    is.close();
                    bos.close();
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block14;
                    logger.debug((Object)e);
                }
            }
        }
    }

    private byte[] getRestoreData(byte[] msg, String msgFileName, byte[] cover, byte[] pass) throws Exception {
        this.image = StegoUtils.byteArrayToImage(cover);
        if (this.image == null) {
            throw new Exception("No se pudo leer la imagen.");
        }
        this.imgWidth = this.image.getWidth();
        this.imgHeight = this.image.getHeight();
        this.fileName = msgFileName;
        this.matrizMaestra = new boolean[this.imgWidth][this.imgHeight][3][config.getMaxBitsPorCanal()];
        int i = 0;
        while (i < this.imgWidth) {
            int j = 0;
            while (j < this.imgHeight) {
                int k = 0;
                while (k < config.getMaxBitsPorCanal()) {
                    this.matrizMaestra[i][j][0][k] = false;
                    this.matrizMaestra[i][j][1][k] = false;
                    this.matrizMaestra[i][j][2][k] = false;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        byte[] r = this.calculateHeader(msg.length, pass);
        byte[] data = this.getRestaurationBytes(msg.length);
        byte[] res = new byte[r.length + data.length];
        System.arraycopy(r, 0, res, 0, r.length);
        System.arraycopy(data, 0, res, r.length, data.length);
        return res;
    }

    private byte[] calculateHeader(int dataLength, byte[] pass) throws StegoException {
        int noOfPixels = this.imgWidth * this.imgHeight;
        int headerSize = 0;
        try {
            this.cabecera = new CabeceraLSB(dataLength, this.channelBitsUsed, this.fileName, config);
            headerSize = this.cabecera.getLongitudCabecera();
            while ((double)(noOfPixels * 3 * this.channelBitsUsed) / 8.0 < (double)(headerSize + dataLength)) {
                if (++this.channelBitsUsed <= config.getMaxBitsPorCanal()) continue;
                throw new StegoException("Los datos no caben. Se han utilizado m\u00e1s bits por canal que el m\u00e1ximo permitido.");
            }
            this.cabecera.setBitsUtilizados(this.channelBitsUsed);
            return this.getRestaurationBytes(this.cabecera.getDatosCabecera(pass).length);
        }
        catch (Exception ex) {
            throw new StegoException(ex);
        }
    }

    private byte[] getRestaurationBytes(int b) throws IOException {
        return this.getRestaurationBytes(0, b);
    }

    private byte[] getRestaurationBytes(int off, int len) throws IOException {
        if (off < 0 || len <= 0 || off + len < 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Posici\u00f3n fuera de rango");
            }
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Longitud de entrada nula");
            }
            return null;
        }
        if (this.image == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No se pudo leer la imagen de entrada");
            }
            return null;
        }
        byte[] res = new byte[len];
        int i = 0;
        while (i < len) {
            res[i] = (byte)this.getRestoreByte();
            ++i;
        }
        return res;
    }

    private int getRestoreByte() throws IOException {
        int x = 0;
        int y = 0;
        int channel = 0;
        int bit = 0;
        byte[] bitSet = new byte[8];
        int i = 0;
        while (i < 8) {
            while (this.matrizMaestra[x = this.rand.nextInt(this.imgWidth)][y = this.rand.nextInt(this.imgHeight)][channel = this.rand.nextInt(3)][bit = this.rand.nextInt(this.channelBitsUsed)]) {
            }
            this.matrizMaestra[x][y][channel][bit] = true;
            bitSet[i] = (byte)this.getPixelBit(x, y, channel, bit);
            ++i;
        }
        return (bitSet[0] << 7) + (bitSet[1] << 6) + (bitSet[2] << 5) + (bitSet[3] << 4) + (bitSet[4] << 3) + (bitSet[5] << 2) + (bitSet[6] << 1) + (bitSet[7] << 0);
    }

    private int getPixelBit(int x, int y, int channel, int bit) {
        return this.image.getRGB(x, y) >> channel * 8 + bit & 1;
    }
}

