/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.crypto.symetric;

import es.mityc.crypto.CryptoManager;
import es.mityc.crypto.Utils;
import es.mityc.javasign.utils.Base64Coder;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TripleDESManager
implements CryptoManager {
    static Log logger = LogFactory.getLog(TripleDESManager.class);
    private Cipher tripleDesCipher = null;
    private SecretKeyFactory skf3Des = null;
    private SecureRandom random = null;
    private static byte[] salt = null;

    public TripleDESManager() {
        this.init();
    }

    @Override
    public void feedSeed(byte[] seed) {
        this.random.nextBytes(salt);
        if (seed != null) {
            int i = 0;
            while (i < salt.length && i < seed.length) {
                TripleDESManager.salt[i] = (byte)(salt[i] & seed[i]);
                ++i;
            }
        }
        this.random.setSeed(salt);
    }

    private void init() {
        es.mityc.javasign.utils.Utils.addBCProvider();
        try {
            this.tripleDesCipher = Cipher.getInstance("DESede", "BC");
            this.skf3Des = SecretKeyFactory.getInstance("DESede", "BC");
        }
        catch (NoSuchPaddingException ex) {
            throw new SecurityException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SecurityException(ex);
        }
        catch (NoSuchProviderException ex) {
            throw new SecurityException(ex);
        }
        salt = SecureRandom.getSeed(8);
        this.random = new SecureRandom(salt);
    }

    public char[] protectTripleDES(String plain, String password) throws SecurityException {
        if (password == null || "".equals(new String(password).trim()) || plain == null) {
            throw new SecurityException("Faltan par\u00e1metros de entrada");
        }
        return this.protectTripleDES(plain.getBytes(), password);
    }

    public char[] protectTripleDES(byte[] plainBytes, String password) throws SecurityException {
        if (password == null || "".equals(new String(password).trim()) || plainBytes == null) {
            throw new SecurityException("Faltan par\u00e1metros de entrada");
        }
        if (password.length() < 24) {
            logger.warn((Object)"La clave debe tener al menos 24 bytes. Se emplea su valor SHA256 como contrase\u00f1a.");
            es.mityc.javasign.utils.Utils.addBCProvider();
            try {
                MessageDigest hash = MessageDigest.getInstance("SHA256", "BC");
                password = new String(hash.digest(password.getBytes()));
            }
            catch (NoSuchAlgorithmException e) {
                throw new SecurityException("Error al calcular el Digest de la contrase\u00f1a", e);
            }
            catch (NoSuchProviderException e) {
                throw new SecurityException("Error al calcular el Digest de la contrase\u00f1a", e);
            }
        }
        try {
            SecretKey desKey = this.skf3Des.generateSecret(new DESedeKeySpec(password.getBytes()));
            return this.protectTripleDES(plainBytes, desKey);
        }
        catch (InvalidKeySpecException ex) {
            throw new SecurityException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new SecurityException(ex);
        }
    }

    public char[] protectTripleDES(byte[] plainBytes, SecretKey key) throws SecurityException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Encriptando " + plainBytes.length + " bytes"));
            }
            this.init();
            this.tripleDesCipher.init(1, (Key)key, this.random);
            byte[] ciphertext = this.tripleDesCipher.doFinal(plainBytes);
            char[] cArray = Base64Coder.encode((byte[])ciphertext);
            return cArray;
        }
        catch (InvalidKeyException ex) {
            throw new SecurityException(ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new SecurityException(ex);
        }
        catch (BadPaddingException ex) {
            throw new SecurityException(ex);
        }
        finally {
            if (Security.getProvider("BC") != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Eliminando el proveedor BC");
                }
                Security.removeProvider("BC");
            }
        }
    }

    public byte[] recoverTripleDES(char[] cryptedText, String password) throws SecurityException {
        if (password == null || "".equals(new String(password).trim()) || cryptedText == null) {
            throw new SecurityException("Faltan par\u00e1metros de entrada");
        }
        if (password.length() < 24) {
            logger.warn((Object)"La clave debe tener al menos 24 bytes. Se emplea su valor SHA256 como contrase\u00f1a.");
            try {
                es.mityc.javasign.utils.Utils.addBCProvider();
                MessageDigest hash = MessageDigest.getInstance("SHA256", "BC");
                password = new String(hash.digest(password.getBytes()));
            }
            catch (NoSuchAlgorithmException e) {
                throw new SecurityException("Error al calcular el Digest de la contrase\u00f1a", e);
            }
            catch (NoSuchProviderException e) {
                throw new SecurityException("Error al calcular el Digest de la contrase\u00f1a", e);
            }
        }
        try {
            SecretKey desKey = this.skf3Des.generateSecret(new DESedeKeySpec(password.getBytes()));
            byte[] byArray = this.recoverTripleDES(cryptedText, desKey);
            return byArray;
        }
        catch (InvalidKeySpecException ex) {
            throw new SecurityException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new SecurityException(ex);
        }
        finally {
            if (Security.getProvider("BC") != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Eliminando el proveedor BC");
                }
                Security.removeProvider("BC");
            }
        }
    }

    public byte[] recoverTripleDES(char[] cryptedText, SecretKey key) throws SecurityException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Recuperando " + cryptedText.length + " bytes"));
            }
            this.init();
            this.tripleDesCipher.init(2, key);
            byte[] byArray = this.tripleDesCipher.doFinal(Base64Coder.decode((Object)cryptedText));
            return byArray;
        }
        catch (InvalidKeyException ex) {
            throw new SecurityException(ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new SecurityException(ex);
        }
        catch (BadPaddingException ex) {
            throw new SecurityException("Contrase\u00f1a incorrecta", ex);
        }
        finally {
            if (Security.getProvider("BC") != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Eliminando el proveedor BC");
                }
                Security.removeProvider("BC");
            }
        }
    }

    public SecretKey genKey() {
        byte[] randomKey = new byte[30];
        this.random.nextBytes(randomKey);
        try {
            return this.skf3Des.generateSecret(new DESedeKeySpec(randomKey));
        }
        catch (Exception e) {
            logger.error((Object)"No se pudo construir la clave aleatoria", (Throwable)e);
            return null;
        }
    }

    public SecretKey rebuildKey(byte[] key) {
        try {
            return this.skf3Des.generateSecret(new DESedeKeySpec(key));
        }
        catch (Exception e) {
            logger.error((Object)"No se pudo reconstruir la clave indicada", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getUsedAlgorithmURI() {
        return "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    }

    public static void main(String[] args) {
        String pass = "1234567890123456789012345678901234567890";
        TripleDESManager p = new TripleDESManager();
        System.out.println("Texto en claro: " + args[0]);
        String buffer = Utils.obfuscate(args[0]);
        System.out.println("Texto ofuscado: " + buffer);
        buffer = Utils.undoObfuscate(buffer.getBytes());
        System.out.println("Texto recuperado: " + buffer);
        char[] bufferChar = p.protectTripleDES(buffer, pass);
        buffer = new String(bufferChar);
        System.out.println("Texto encriptado triple DES: " + buffer);
        buffer = new String(p.recoverTripleDES(bufferChar, pass));
        System.out.println("Texto desencriptado triple DES: " + buffer);
        long start = System.currentTimeMillis();
        buffer = Utils.obfuscate(new String(p.protectTripleDES(buffer, pass)));
        System.out.println("Encriptado y ofuscado triple DES: " + buffer);
        buffer = new String(p.recoverTripleDES(Utils.undoObfuscate(buffer.getBytes()).toCharArray(), pass));
        long time = System.currentTimeMillis() - start;
        System.out.println("Texto recuperado: " + buffer + "\nTiempo consumido (ms): " + time);
    }
}

