/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.jse.provider;

import es.gob.jmulticard.card.CryptoCardException;
import es.gob.jmulticard.card.dnie.a;
import es.gob.jmulticard.card.dnie.e;
import es.gob.jmulticard.jse.provider.DniePrivateKey;
import es.gob.jmulticard.jse.provider.DnieProvider;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;

abstract class DnieSignatureImpl
extends SignatureSpi {
    private final ByteArrayOutputStream a = new ByteArrayOutputStream();
    private Signature b = null;
    private DniePrivateKey c = null;
    private final String d;

    DnieSignatureImpl(String string) {
        this.d = string;
    }

    @Override
    protected Object engineGetParameter(String string) {
        throw new InvalidParameterException("Parametro no soportado");
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) {
        if (privateKey == null) {
            throw new InvalidKeyException("La clave proporcionada es nula");
        }
        if (!(privateKey instanceof DniePrivateKey)) {
            throw new InvalidKeyException("La clave proporcionada no es de un DNIe: " + privateKey.getClass().getName());
        }
        this.c = (DniePrivateKey)privateKey;
        this.a.reset();
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) {
        this.a.reset();
        try {
            this.b = Signature.getInstance(this.d);
            try {
                if (this.b.getProvider() instanceof DnieProvider) {
                    this.b = Signature.getInstance(this.d, "SunRsaSign");
                }
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new IllegalStateException("No esta instalado el proveedor SunRsaSign", noSuchProviderException);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("No existe un proveedor para validar firmas con el algoritmo " + this.d, noSuchAlgorithmException);
        }
        this.b.initVerify(publicKey);
    }

    @Override
    protected void engineSetParameter(String string, Object object) {
        throw new InvalidParameterException("Parametro no soportado");
    }

    @Override
    protected byte[] engineSign() {
        if (!(this.c.a() instanceof a)) {
            throw new ProviderException("La clave proporcionada no se corresponde con la de un DNIe");
        }
        e e2 = new e((a)this.c.a(), this.c.b(), this.c.c(), this.c.toString());
        try {
            return this.c.a().a(this.a.toByteArray(), this.d, e2);
        }
        catch (CryptoCardException cryptoCardException) {
            throw new SignatureException(cryptoCardException);
        }
    }

    @Override
    protected void engineUpdate(byte by) {
        this.a.write(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        this.a.write(byArray, n2, n3);
    }

    @Override
    protected boolean engineVerify(byte[] byArray) {
        if (this.b == null) {
            throw new SignatureException("La verificacion no esta inicializada");
        }
        this.b.update(this.a.toByteArray());
        this.a.reset();
        return this.b.verify(byArray);
    }
}

