/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades;

public enum CanonicalizationEnum {
    UNKNOWN("unknown"),
    C14N_OMIT_COMMENTS("http://www.w3.org/TR/2001/REC-xml-c14n-20010315"),
    C14N_WITH_COMMENTS("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments"),
    C14N_EXCL_OMIT_COMMENTS("http://www.w3.org/2001/10/xml-exc-c14n#"),
    C14N_EXCL_WITH_COMMENTS("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");

    private String value;

    private CanonicalizationEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static CanonicalizationEnum getCanonicalization(String value) {
        if (value != null) {
            if ("http://www.w3.org/TR/2001/REC-xml-c14n-20010315".equals(value)) {
                return C14N_OMIT_COMMENTS;
            }
            if ("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments".equals(value)) {
                return C14N_WITH_COMMENTS;
            }
            if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(value)) {
                return C14N_EXCL_OMIT_COMMENTS;
            }
            if ("http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(value)) {
                return C14N_EXCL_WITH_COMMENTS;
            }
        }
        return UNKNOWN;
    }
}

