/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos.xades;

import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.AbstractXADESElement;
import es.mityc.firmaJava.libreria.xades.elementos.xades.DocumentationReference;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentationReferencesType
extends AbstractXADESElement {
    private ArrayList<DocumentationReference> references;

    public DocumentationReferencesType(XAdESSchemas schema) {
        super(schema);
    }

    public DocumentationReferencesType(XAdESSchemas schema, ArrayList<DocumentationReference> list) {
        super(schema);
        this.references = list;
    }

    public ArrayList<DocumentationReference> getList() {
        return this.references;
    }

    public void setList(ArrayList<DocumentationReference> list) {
        this.references = list;
    }

    public void addReference(DocumentationReference qualifier) {
        if (this.references == null) {
            this.references = new ArrayList();
        }
        this.references.add(qualifier);
    }

    public void addReference(URI uri) {
        if (this.references == null) {
            this.references = new ArrayList();
        }
        this.references.add(new DocumentationReference(this.schema, uri));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DocumentationReferencesType) {
            DocumentationReferencesType cvt = (DocumentationReferencesType)obj;
            ArrayList<DocumentationReference> comp = cvt.references;
            if ((this.references == null || this.references.isEmpty()) && (comp == null || comp.isEmpty())) {
                return true;
            }
            if (this.references != null && comp != null && this.references.size() == comp.size()) {
                Iterator<DocumentationReference> itThis = this.references.iterator();
                Iterator<DocumentationReference> itComp = comp.iterator();
                while (itThis.hasNext()) {
                    if (itThis.next().equals(itComp.next())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected void addContent(Element element) throws InvalidInfoNodeException {
        if (this.references != null && this.references.size() > 0) {
            Iterator<DocumentationReference> it = this.references.iterator();
            while (it.hasNext()) {
                element.appendChild(it.next().createElement(element.getOwnerDocument(), this.namespaceXAdES));
            }
        } else {
            throw new InvalidInfoNodeException("Nodo DocumentationReferencesType no tiene ning\u00fan hijo");
        }
    }

    @Override
    public void addContent(Element element, String namespaceXAdES) throws InvalidInfoNodeException {
        super.addContent(element, namespaceXAdES);
    }

    @Override
    public void load(Element element) throws InvalidInfoNodeException {
        NodeList nodos = element.getChildNodes();
        ArrayList<DocumentationReference> temp = new ArrayList<DocumentationReference>(nodos.getLength());
        int i = 0;
        while (i < nodos.getLength()) {
            Node nodo = nodos.item(i);
            if (!DocumentationReferencesType.isDecorationNode(nodo)) {
                if (nodo.getNodeType() != 1) {
                    throw new InvalidInfoNodeException("Hijo de DocumentationReferencesType no es un elemento");
                }
                DocumentationReference reference = new DocumentationReference(this.schema);
                reference.load((Element)nodo);
                temp.add(reference);
            }
            ++i;
        }
        if (temp.size() == 0) {
            throw new InvalidInfoNodeException("DocumentationReferencesType debe tener al menos un hijo");
        }
        this.references = temp;
    }
}

