/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.xml.resolvers;

import adsi.org.apache.xml.security.signature.XMLSignatureInput;
import adsi.org.apache.xml.security.utils.resolver.ResourceResolverException;
import es.mityc.javasign.xml.resolvers.IPrivateData;
import es.mityc.javasign.xml.resolvers.MITyCResourceResolver;
import es.mityc.javasign.xml.resolvers.ResourceDataException;
import org.w3c.dom.Attr;

public class ResolverPrivateData
extends MITyCResourceResolver {
    private static final String[] keys = new String[]{"digest.algorithm"};
    private IPrivateData internalResolver;

    public ResolverPrivateData(IPrivateData internalResolver) {
        this.internalResolver = internalResolver;
    }

    public boolean engineCanResolve(Attr uri, String BaseURI) {
        if (this.internalResolver == null) {
            return false;
        }
        return this.internalResolver.canDigest(uri.getValue(), BaseURI);
    }

    public XMLSignatureInput engineResolve(Attr uri, String BaseURI) throws ResourceResolverException {
        if (this.internalResolver == null) {
            throw new ResourceResolverException("", uri, BaseURI);
        }
        String algName = this.engineGetProperty("digest.algorithm");
        if (algName == null) {
            throw new ResourceResolverException("", uri, BaseURI);
        }
        try {
            byte[] data = this.internalResolver.getDigest(uri.getValue(), BaseURI, algName);
            XMLSignatureInput xsi = new XMLSignatureInput(data);
            return xsi;
        }
        catch (ResourceDataException ex) {
            throw new ResourceResolverException("", uri, BaseURI);
        }
    }

    public boolean engineIsPrivateData() {
        return true;
    }

    public String[] engineGetPropertyKeys() {
        return keys;
    }
}

